/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.figure.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.vermulst.multibreak.figure.FigureIterable;
import me.vermulst.multibreak.figure.types.FigureType;
import org.bukkit.util.Vector;

public class FigureTriangle
extends FigureIterable {
    public FigureTriangle(int width, int height, int depth) {
        super(width, height, depth);
    }

    @Override
    public Set<Vector> getVectors(boolean rotated) {
        int[] widthBound = this.getBoundPair(this.getWidth(), this.getOffSetWidth());
        int[] heightBound = this.getBoundPair(this.getHeight(), this.getOffSetHeight());
        int[] depthBound = this.getBoundPair(this.getDepth(), this.getOffSetDepth());
        ArrayList<Vector> triangles = new ArrayList<Vector>();
        Vector vertexTop = new Vector(this.getOffSetWidth(), heightBound[1], this.getOffSetDepth());
        Vector vertexLeft = new Vector(widthBound[0], heightBound[0], this.getOffSetDepth());
        Vector vertexRight = new Vector(widthBound[1], heightBound[0], this.getOffSetDepth());
        for (int i = depthBound[0]; i <= depthBound[1]; ++i) {
            triangles.add(vertexTop.clone().add(new Vector(0, 0, i)));
            triangles.add(vertexLeft.clone().add(new Vector(0, 0, i)));
            triangles.add(vertexRight.clone().add(new Vector(0, 0, i)));
        }
        Set<Vector> vectors = this.iterateOverBoundingBox(triangles, rotated);
        vectors.removeIf(vector -> !this.isPointInAnyTriangle((Vector)vector, (List<Vector>)triangles));
        return vectors;
    }

    private boolean isPointInAnyTriangle(Vector point, List<Vector> triangles) {
        for (int i = 0; i < triangles.size(); i += 3) {
            if (point.getZ() != triangles.get(i).getZ() || !this.isPointInTriangle(point, triangles.get(i), triangles.get(i + 1), triangles.get(i + 2))) continue;
            return true;
        }
        return false;
    }

    private boolean isPointInTriangle(Vector point, Vector v1, Vector v2, Vector v3) {
        double x = point.getX();
        double y = point.getY();
        double x1 = v1.getX();
        double y1 = v1.getY();
        double x2 = v2.getX();
        double y2 = v2.getY();
        double x3 = v3.getX();
        double y3 = v3.getY();
        double denominator = (y2 - y3) * (x1 - x3) + (x3 - x2) * (y1 - y3);
        double alpha = ((y2 - y3) * (x - x3) + (x3 - x2) * (y - y3)) / denominator;
        double beta = ((y3 - y1) * (x - x3) + (x1 - x3) * (y - y3)) / denominator;
        double gamma = 1.0 - alpha - beta;
        return alpha >= 0.0 && beta >= 0.0 && gamma >= 0.0 && alpha <= 1.0 && beta <= 1.0 && gamma <= 1.0;
    }

    public int[] getBoundPair(int length, int offSetRight) {
        double bound = (double)(length - 1) / 2.0;
        int lowerBound = (int)Math.ceil(bound);
        int higherBound = (int)Math.floor(bound);
        return new int[]{-lowerBound + offSetRight, higherBound + offSetRight};
    }

    @Override
    public FigureType getFigureType() {
        return FigureType.TRIANGULAR;
    }
}

