/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.vermulst.multibreak.Main;
import me.vermulst.multibreak.api.event.MultiBreakAllowEvent;
import me.vermulst.multibreak.api.event.MultiBreakEndEvent;
import me.vermulst.multibreak.api.event.MultiBreakStartEvent;
import me.vermulst.multibreak.config.ConfigManager;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.item.FigureItemDataType;
import me.vermulst.multibreak.multibreak.MultiBreak;
import me.vermulst.multibreak.multibreak.MultiBreakRunnable;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageAbortEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BreakManager
implements Listener {
    private final Main plugin;
    private final Map<UUID, Integer> multiBreakTask = new HashMap<UUID, Integer>();
    private final Map<UUID, MultiBreak> multiBlockMap = new HashMap<UUID, MultiBreak>();

    public BreakManager(Main plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void multiBreakStart(BlockDamageEvent e) {
        Player p = e.getPlayer();
        boolean allowed = this.hasFigure(e.getItemInHand());
        MultiBreakAllowEvent multiBreakAllowEvent = new MultiBreakAllowEvent(allowed, p, e.getItemInHand(), e.getBlock());
        multiBreakAllowEvent.callEvent();
        if (!multiBreakAllowEvent.isAllowed()) {
            return;
        }
        this.scheduleMultiBreak(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void multiBreakStop(BlockDamageAbortEvent e) {
        Player p = e.getPlayer();
        MultiBreak multiBreak = this.getOrCreateMultiBreak(p);
        if (multiBreak == null) {
            return;
        }
        MultiBreakEndEvent event = new MultiBreakEndEvent(p, multiBreak, false);
        event.callEvent();
        this.endMultiBreak(p, multiBreak, false);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void breakBlockType(BlockBreakEvent e) {
        if (this.ignoreMultiBreak(e)) {
            return;
        }
        Player p = e.getPlayer();
        MultiBreak multiBreak = this.getOrCreateMultiBreak(p);
        if (multiBreak == null) {
            return;
        }
        Block block = e.getBlock();
        if (!block.equals(multiBreak.getBlock())) {
            multiBreak = this.initMultiBreak(p, block);
        }
        MultiBreakEndEvent event = new MultiBreakEndEvent(p, multiBreak, true);
        event.callEvent();
        if (event.isCancelled()) {
            return;
        }
        if (event.getMultiBreak() == null) {
            return;
        }
        this.endMultiBreak(p, event.getMultiBreak(), true);
    }

    private boolean ignoreMultiBreak(BlockBreakEvent e) {
        Block block = e.getBlock();
        boolean b1 = block.hasMetadata("multi-broken");
        boolean b2 = this.plugin.getConfigManager().getIgnoredMaterials().contains(block.getType());
        boolean b3 = e.isCancelled();
        if (block.hasMetadata("multi-broken")) {
            block.removeMetadata("multi-broken", (Plugin)this.getPlugin());
        }
        return b1 || b2 || b3;
    }

    public void scheduleMultiBreak(Player p) {
        Block block = this.getTargetBlock(p);
        MultiBreakRunnable multiBreakRunnable = new MultiBreakRunnable(block, p, this);
        int taskID = multiBreakRunnable.runTaskTimer((Plugin)this.getPlugin(), 1L, 1L).getTaskId();
        this.getMultiBreakTask().put(p.getUniqueId(), taskID);
    }

    public void endMultiBreak(Player p, MultiBreak multiBreak, boolean finished) {
        UUID uuid = p.getUniqueId();
        multiBreak.end(finished, this.getPlugin());
        this.getMultiBlockMap().remove(uuid);
        if (!this.getMultiBreakTask().containsKey(uuid)) {
            return;
        }
        Bukkit.getScheduler().cancelTask(this.getMultiBreakTask().get(uuid).intValue());
    }

    public MultiBreak getOrCreateMultiBreak(Player p) {
        MultiBreak multiBreak;
        if (p.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return null;
        }
        if (this.multiBlockMap.containsKey(p.getUniqueId()) && !(multiBreak = this.multiBlockMap.get(p.getUniqueId())).hasEnded()) {
            return multiBreak;
        }
        Block blockMining = this.getTargetBlock(p);
        return this.initMultiBreak(p, blockMining);
    }

    public MultiBreak initMultiBreak(Player p, Block block) {
        ItemStack tool = p.getInventory().getItemInMainHand();
        Figure figure = this.getFigure(tool);
        BlockFace blockFace = this.getBlockFace(p);
        if (block == null || blockFace == null) {
            return null;
        }
        ConfigManager config = this.plugin.getConfigManager();
        EnumSet<Material> includedMaterials = config.getIncludedMaterials();
        EnumSet<Material> ignoredMaterials = config.getIgnoredMaterials();
        MultiBreak multiBreak = new MultiBreak(p, block, figure, blockFace.getDirection());
        MultiBreakStartEvent event = new MultiBreakStartEvent(p, multiBreak, block, blockFace.getDirection(), includedMaterials, ignoredMaterials);
        if (!event.callEvent()) {
            return null;
        }
        includedMaterials = event.getIncludedMaterials();
        ignoredMaterials = event.getExcludedMaterials();
        multiBreak = event.getMultiBreak();
        if (!multiBreak.isValid(includedMaterials, ignoredMaterials)) {
            return null;
        }
        float breakSpeed = multiBreak.getBlock().getBreakSpeed(p);
        multiBreak.checkValid(breakSpeed, includedMaterials, ignoredMaterials);
        this.multiBlockMap.put(p.getUniqueId(), multiBreak);
        return multiBreak;
    }

    public Figure getFigure(ItemStack tool) {
        if (tool.getItemMeta() == null) {
            return null;
        }
        FigureItemDataType figureItemDataType = new FigureItemDataType((Plugin)this.getPlugin());
        Figure figure = figureItemDataType.get(tool);
        if (figure != null) {
            return figure;
        }
        Material material = tool.getType();
        ConfigManager configManager = this.getPlugin().getConfigManager();
        if (configManager.getMaterialOptions().containsKey(material)) {
            String configOptionName = configManager.getMaterialOptions().get(material);
            return configManager.getConfigOptions().get(configOptionName);
        }
        return null;
    }

    public boolean hasFigure(ItemStack tool) {
        if (tool.getItemMeta() == null) {
            return false;
        }
        FigureItemDataType figureItemDataType = new FigureItemDataType((Plugin)this.getPlugin());
        boolean toolHasMultibreak = figureItemDataType.has(tool);
        Material material = tool.getType();
        ConfigManager configManager = this.getPlugin().getConfigManager();
        boolean materialHasMultibreak = configManager.getMaterialOptions().containsKey(material);
        return toolHasMultibreak || materialHasMultibreak;
    }

    public Block getTargetBlock(Player p) {
        return p.getTargetBlockExact(this.plugin.getConfigManager().getMaxRange());
    }

    public BlockFace getBlockFace(Player p) {
        return p.getTargetBlockFace(this.plugin.getConfigManager().getMaxRange());
    }

    public Main getPlugin() {
        return this.plugin;
    }

    public Map<UUID, Integer> getMultiBreakTask() {
        return this.multiBreakTask;
    }

    public Map<UUID, MultiBreak> getMultiBlockMap() {
        return this.multiBlockMap;
    }
}

