/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak;

import com.destroystokyo.paper.ParticleBuilder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import me.vermulst.multibreak.Main;
import me.vermulst.multibreak.config.ConfigManager;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.figure.VectorTransformer;
import me.vermulst.multibreak.multibreak.MultiBlock;
import me.vermulst.multibreak.utils.CompassDirection;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class MultiBreak {
    private final Player p;
    private final Block block;
    private final Vector playerDirection;
    private int progressTicks;
    private float progressBroken;
    private List<MultiBlock> multiBlocks = new ArrayList<MultiBlock>();
    private boolean ended = false;

    public MultiBreak(Player p, Block block, Figure figure, Vector playerDirection) {
        this.p = p;
        this.block = block;
        this.playerDirection = playerDirection;
        this.initBlocks(figure, playerDirection);
        float breakSpeed = this.getBlock().getBreakSpeed(this.getPlayer());
        float destroySpeed = 1.0E-6f + 1.0f / breakSpeed;
        this.progressBroken = 1.0f / destroySpeed;
    }

    public void setFigure(Figure figure) {
        this.initBlocks(figure, this.playerDirection);
    }

    public boolean isValid(EnumSet<Material> includedMaterials, EnumSet<Material> excludedMaterials) {
        Material mainBlockType = this.getBlock().getType();
        if (includedMaterials != null && !includedMaterials.isEmpty() && !includedMaterials.contains(mainBlockType)) {
            return false;
        }
        return excludedMaterials == null || excludedMaterials.isEmpty() || !excludedMaterials.contains(mainBlockType);
    }

    public void checkValid(float breakSpeed, EnumSet<Material> includedMaterials, EnumSet<Material> excludedMaterials) {
        if (includedMaterials != null && !includedMaterials.isEmpty()) {
            this.getMultiBlocks().removeIf(multiBlock -> !includedMaterials.contains(multiBlock.getBlock().getType()));
        }
        if (excludedMaterials != null && !excludedMaterials.isEmpty()) {
            this.getMultiBlocks().removeIf(multiBlock -> excludedMaterials.contains(multiBlock.getBlock().getType()));
        }
        this.getMultiBlocks().removeIf(multiBlock -> multiBlock.getBlock().getType().equals((Object)Material.AIR));
        ConfigManager config = Main.getInstance().getConfigManager();
        boolean fairMode = config.getOptions()[0];
        if (!fairMode) {
            return;
        }
        float fairModeLeeway = (float)Main.getInstance().getConfigManager().getFairModeTicksLeeway() * 0.05f;
        this.getMultiBlocks().removeIf(multiBlock -> multiBlock.getBlock().getBreakSpeed(this.getPlayer()) + fairModeLeeway < breakSpeed);
    }

    public void initBlocks(Figure figure, Vector playerDirection) {
        this.multiBlocks = new ArrayList<MultiBlock>();
        if (figure == null) {
            return;
        }
        CompassDirection compassDirection = CompassDirection.getCompassDir(this.getPlayer().getLocation());
        boolean rotated = (double)figure.getRotationWidth() != 0.0 || (double)figure.getRotationHeight() != 0.0 || (double)figure.getRotationDepth() != 0.0;
        Set<Vector> blockVectors = figure.getVectors(rotated);
        if (rotated) {
            blockVectors = figure.applyRotation(blockVectors, figure);
        }
        VectorTransformer vectorTransformer = new VectorTransformer(playerDirection, compassDirection);
        for (Vector vector : blockVectors) {
            vectorTransformer.rotateVector(vector);
        }
        blockVectors.remove(new Vector(0, 0, 0));
        Location loc = this.getBlock().getLocation();
        for (Vector vector : blockVectors) {
            Block block = loc.clone().add(vector).getBlock();
            Material type = block.getType();
            if (block.isLiquid() || !type.isItem()) continue;
            MultiBlock multiBlock = new MultiBlock(block);
            this.getMultiBlocks().add(multiBlock);
        }
    }

    @Deprecated
    public void tick(Main plugin, Block blockMining) {
        if (!blockMining.equals(this.getBlock())) {
            this.end(false, plugin);
        }
        ++this.progressTicks;
        if (this.progressTicks % 2 == 0) {
            this.playParticles();
        }
        this.updateBlockAnimationPacket();
        this.scheduleCancel(plugin, blockMining);
    }

    public void tick() {
        ++this.progressTicks;
        if (this.progressTicks % 2 == 0) {
            this.playParticles();
        }
        this.updateBlockAnimationPacket();
    }

    public void end(boolean finished, Main plugin) {
        this.ended = true;
        for (MultiBlock multiBlock : this.getMultiBlocks()) {
            multiBlock.writeStage(this.getPlayer(), 0.0f);
        }
        if (!finished) {
            return;
        }
        ParticleBuilder particleBuilder = new ParticleBuilder(Particle.ITEM_CRACK).count(4).offset(1.0, 0.1, 0.1).extra(0.1);
        World world = this.getBlock().getWorld();
        int size = this.getMultiBlocks().size() - 1;
        float volume = (float)(1.0 / Math.log((double)(size + 1) * Math.E));
        for (MultiBlock multiBlock : this.getMultiBlocks()) {
            if (!multiBlock.breakThisBlock()) continue;
            Block block = multiBlock.getBlock();
            Material blockType = block.getType();
            BlockData blockData = block.getBlockData().clone();
            Location location = block.getLocation();
            if (plugin.getConfigManager().getIgnoredMaterials().contains(blockType)) continue;
            block.setMetadata("multi-broken", (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)true));
            boolean broken = this.getPlayer().breakBlock(block);
            if (!broken) continue;
            if (multiBlock.getDrops() != null) {
                for (ItemStack drop : multiBlock.getDrops()) {
                    world.dropItemNaturally(location, drop);
                }
            }
            world.playSound(location, blockData.getSoundGroup().getBreakSound(), volume, 1.0f);
            if (!multiBlock.isVisible()) continue;
            particleBuilder.data((Object)new ItemStack(blockType));
            particleBuilder.location(location.add(0.5, 0.0, 0.5)).spawn();
        }
    }

    public void playParticles() {
        ParticleBuilder particleBuilder = new ParticleBuilder(Particle.BLOCK_CRACK).offset(0.375, 0.0, 0.375);
        HashMap<Material, BlockData> blockDataHashMap = new HashMap<Material, BlockData>();
        for (MultiBlock multiBlock : this.getMultiBlocks()) {
            if (multiBlock.getBlock().equals(this.getBlock()) || !multiBlock.isVisible()) continue;
            Block block1 = multiBlock.getBlock();
            BlockData blockData = blockDataHashMap.computeIfAbsent(block1.getType(), data -> block1.getType().createBlockData());
            particleBuilder.location(block1.getLocation().add(0.5, 1.0, 0.5)).data((Object)blockData).spawn();
        }
    }

    public void updateBlockAnimationPacket() {
        float breakSpeed = this.getBlock().getBreakSpeed(this.getPlayer());
        float destroySpeed = 1.0E-6f + 1.0f / breakSpeed;
        this.progressBroken += 1.0f / destroySpeed;
        this.progressBroken = Math.min(this.progressBroken, 1.0f);
        this.progressBroken = Math.max(this.progressBroken, 0.0f);
        for (MultiBlock multiBlock : this.getMultiBlocks()) {
            if (multiBlock.getBlock().equals(this.getBlock()) || !multiBlock.isVisible()) continue;
            multiBlock.writeStage(this.getPlayer(), this.progressBroken);
        }
    }

    public void scheduleCancel(final Main plugin, final Block targetBlock) {
        final int currentProgress = this.progressTicks;
        new BukkitRunnable(){

            public void run() {
                boolean target;
                boolean progress = currentProgress != MultiBreak.this.getProgressTicks();
                boolean bl = target = targetBlock == null || targetBlock.equals(MultiBreak.this.p.getLastTwoTargetBlocks(null, 10).get(1));
                if (target && progress) {
                    return;
                }
                for (MultiBlock multiBlock : MultiBreak.this.getMultiBlocks()) {
                    if (!multiBlock.isVisible()) continue;
                    multiBlock.writeStage(MultiBreak.this.getPlayer(), 0.0f);
                }
                MultiBreak.this.end(false, plugin);
            }
        }.runTaskLater((Plugin)plugin, 2L);
    }

    public Player getPlayer() {
        return this.p;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getProgressTicks() {
        return this.progressTicks;
    }

    public List<MultiBlock> getMultiBlocks() {
        return this.multiBlocks;
    }

    public Vector getPlayerDirection() {
        return this.playerDirection;
    }

    public List<Block> getBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (MultiBlock multiBlock : this.getMultiBlocks()) {
            blocks.add(multiBlock.getBlock());
        }
        return blocks;
    }

    public boolean hasEnded() {
        return this.ended;
    }

    public void setProgressTicks(int progressTicks) {
        this.progressTicks = progressTicks;
    }

    public void setProgressBroken(float progressBroken) {
        this.progressBroken = progressBroken;
    }

    public float getProgressBroken() {
        return this.progressBroken;
    }

    public String toString() {
        return "MultiBreak{p=" + this.p + ", block=" + this.block + ", playerDirection=" + this.playerDirection + ", progressTicks=" + this.progressTicks + ", multiBlocks=" + this.multiBlocks + ", ended=" + this.ended + "}";
    }
}

