/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.item;

import me.vermulst.multibreak.Main;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.figure.types.FigureType;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class FigureItemDataType
implements PersistentDataType<PersistentDataContainer, Figure> {
    public Figure figure;

    public ItemStack set(ItemStack itemStack, Figure figure) {
        NamespacedKey key = new NamespacedKey((Plugin)Main.getInstance(), "figure_info");
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer customItemTagContainer = itemMeta.getPersistentDataContainer();
        customItemTagContainer.set(key, (PersistentDataType)this, (Object)figure);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public Figure get(ItemStack itemStack) {
        NamespacedKey key;
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer customItemTagContainer = meta.getPersistentDataContainer();
        Figure figure = (Figure)customItemTagContainer.get(key = new NamespacedKey((Plugin)Main.getInstance(), "figure_info"), (PersistentDataType)this);
        if (figure != null) {
            return figure;
        }
        LegacyFigureItemDataType legacyType = new LegacyFigureItemDataType();
        FigureItemInfo oldInfo = (FigureItemInfo)customItemTagContainer.get(key, (PersistentDataType)legacyType);
        if (oldInfo != null) {
            figure = oldInfo.figure();
            customItemTagContainer.remove(key);
            this.set(itemStack, figure);
            return figure;
        }
        return null;
    }

    public ItemStack remove(ItemStack itemStack) {
        NamespacedKey key = new NamespacedKey((Plugin)Main.getInstance(), "figure_info");
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer customItemTagContainer = itemMeta.getPersistentDataContainer();
        customItemTagContainer.remove(key);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public boolean has(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer customItemTagContainer = meta.getPersistentDataContainer();
        NamespacedKey key = new NamespacedKey((Plugin)Main.getInstance(), "figure_info");
        return customItemTagContainer.has(key, PersistentDataType.TAG_CONTAINER);
    }

    @NotNull
    public Class<PersistentDataContainer> getPrimitiveType() {
        return PersistentDataContainer.class;
    }

    @NotNull
    public Class<Figure> getComplexType() {
        return Figure.class;
    }

    @NotNull
    public PersistentDataContainer toPrimitive(Figure figureInfo, PersistentDataAdapterContext persistentDataAdapterContext) {
        PersistentDataContainer persistentDataContainer = persistentDataAdapterContext.newPersistentDataContainer();
        persistentDataContainer.set(this.key("width"), PersistentDataType.INTEGER, (Object)figureInfo.getWidth());
        persistentDataContainer.set(this.key("height"), PersistentDataType.INTEGER, (Object)figureInfo.getHeight());
        persistentDataContainer.set(this.key("depth"), PersistentDataType.INTEGER, (Object)figureInfo.getDepth());
        if (figureInfo.getRotationWidth() != 0) {
            persistentDataContainer.set(this.key("widthR"), PersistentDataType.SHORT, (Object)figureInfo.getRotationWidth());
        }
        if (figureInfo.getRotationHeight() != 0) {
            persistentDataContainer.set(this.key("heightR"), PersistentDataType.SHORT, (Object)figureInfo.getRotationHeight());
        }
        if (figureInfo.getRotationDepth() != 0) {
            persistentDataContainer.set(this.key("depthR"), PersistentDataType.SHORT, (Object)figureInfo.getRotationDepth());
        }
        if (figureInfo.getOffSetWidth() != 0) {
            persistentDataContainer.set(this.key("widthO"), PersistentDataType.INTEGER, (Object)figureInfo.getOffSetWidth());
        }
        if (figureInfo.getOffSetHeight() != 0) {
            persistentDataContainer.set(this.key("heightO"), PersistentDataType.INTEGER, (Object)figureInfo.getOffSetHeight());
        }
        if (figureInfo.getOffSetDepth() != 0) {
            persistentDataContainer.set(this.key("depthO"), PersistentDataType.INTEGER, (Object)figureInfo.getOffSetDepth());
        }
        persistentDataContainer.set(this.key("type_id"), PersistentDataType.INTEGER, (Object)figureInfo.getFigureType().ordinal());
        return persistentDataContainer;
    }

    @NotNull
    public Figure fromPrimitive(PersistentDataContainer persistentDataContainer, @NotNull PersistentDataAdapterContext persistentDataAdapterContext) {
        int width = (Integer)persistentDataContainer.getOrDefault(this.key("width"), PersistentDataType.INTEGER, (Object)3);
        int height = (Integer)persistentDataContainer.getOrDefault(this.key("height"), PersistentDataType.INTEGER, (Object)3);
        int depth = (Integer)persistentDataContainer.getOrDefault(this.key("depth"), PersistentDataType.INTEGER, (Object)1);
        int figureTypeOrdinal = (Integer)persistentDataContainer.getOrDefault(this.key("type_id"), PersistentDataType.INTEGER, (Object)0);
        FigureType figureType = FigureType.values()[figureTypeOrdinal];
        Figure figure = figureType.build(width, height, depth);
        short widthR = (Short)persistentDataContainer.getOrDefault(this.key("widthR"), PersistentDataType.SHORT, (Object)0);
        short heightR = (Short)persistentDataContainer.getOrDefault(this.key("heightR"), PersistentDataType.SHORT, (Object)0);
        short depthR = (Short)persistentDataContainer.getOrDefault(this.key("depthR"), PersistentDataType.SHORT, (Object)0);
        int widthO = (Integer)persistentDataContainer.getOrDefault(this.key("widthO"), PersistentDataType.INTEGER, (Object)0);
        int heightO = (Integer)persistentDataContainer.getOrDefault(this.key("heightO"), PersistentDataType.INTEGER, (Object)0);
        int depthO = (Integer)persistentDataContainer.getOrDefault(this.key("depthO"), PersistentDataType.INTEGER, (Object)0);
        figure.setRotations(widthR, heightR, depthR);
        figure.setOffsets(widthO, heightO, depthO);
        return figure;
    }

    private NamespacedKey key(String key) {
        return new NamespacedKey((Plugin)Main.getInstance(), key);
    }

    private int getOrDefault(Integer integer, int defaultValue) {
        return integer != null ? integer : defaultValue;
    }

    private boolean fromByte(Byte byteValue, boolean defaultValue) {
        return byteValue != null ? byteValue == 1 : defaultValue;
    }

    private class LegacyFigureItemDataType
    implements PersistentDataType<PersistentDataContainer, FigureItemInfo> {
        private LegacyFigureItemDataType() {
        }

        @NotNull
        public Class<PersistentDataContainer> getPrimitiveType() {
            return PersistentDataContainer.class;
        }

        @NotNull
        public Class<FigureItemInfo> getComplexType() {
            return FigureItemInfo.class;
        }

        @NotNull
        public PersistentDataContainer toPrimitive(FigureItemInfo figureInfo, PersistentDataAdapterContext persistentDataAdapterContext) {
            return FigureItemDataType.this.toPrimitive(figureInfo.figure(), persistentDataAdapterContext);
        }

        @NotNull
        public FigureItemInfo fromPrimitive(PersistentDataContainer persistentDataContainer, @NotNull PersistentDataAdapterContext persistentDataAdapterContext) {
            Figure figure = FigureItemDataType.this.fromPrimitive(persistentDataContainer, persistentDataAdapterContext);
            return new FigureItemInfo(figure);
        }
    }

    public record FigureItemInfo(Figure figure) {
    }
}

