/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak;

import com.destroystokyo.paper.ParticleBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.vermulst.multibreak.Main;
import me.vermulst.multibreak.config.Config;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.multibreak.MultiBlock;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class MultiBreak {
    private final UUID playerUUID;
    private Set<UUID> nearbyPlayers;
    private final Block block;
    private final Vector playerDirection;
    private int progressTicks;
    private float progressBroken;
    private List<MultiBlock> multiBlocks = new ArrayList<MultiBlock>();
    private boolean ended = false;

    public MultiBreak(Player p, Block block, Vector playerDirection, Figure figure) {
        this.playerUUID = p.getUniqueId();
        this.nearbyPlayers = this.getNearbyPlayers(block.getLocation());
        this.block = block;
        this.playerDirection = playerDirection;
        this.initBlocks(figure);
        float progressPerTick = this.getBlock().getBreakSpeed(this.getPlayer());
        float destroySpeedTicks = 1.0E-6f + 1.0f / progressPerTick;
        this.progressBroken = 1.0f / destroySpeedTicks;
    }

    public void initBlocks(Figure figure) {
        Player p = this.getPlayer();
        if (p == null) {
            return;
        }
        this.multiBlocks = new ArrayList<MultiBlock>();
        if (figure == null) {
            return;
        }
        Set<Block> blocks = figure.getBlocks(p, this.getBlock());
        for (Block block : blocks) {
            MultiBlock multiBlock = new MultiBlock(block);
            this.getMultiBlocks().add(multiBlock);
        }
    }

    public void tick() {
        if (this.getPlayer() == null) {
            this.end(false);
            return;
        }
        ++this.progressTicks;
        if (this.progressTicks % 20 == 0) {
            this.checkPlayers();
        }
        this.checkRemove();
        if (this.progressTicks % 2 == 0) {
            this.playParticles();
        }
        this.updateBlockAnimationPacket();
    }

    public void end(boolean finished) {
        this.ended = true;
        this.writeStage(0.0f);
        if (!finished) {
            return;
        }
        ParticleBuilder particleBuilder = new ParticleBuilder(Particle.BLOCK).count(16).offset(0.5, 0.5, 0.5);
        World world = this.getBlock().getWorld();
        int size = this.getMultiBlocks().size() - 1;
        float volume = (float)(1.0 / Math.log((double)(size + 1) * Math.E));
        for (MultiBlock multiBlock : this.getMultiBlocks()) {
            if (!multiBlock.breakThisBlock()) continue;
            Block block = multiBlock.getBlock();
            Material blockType = block.getType();
            BlockData blockData = block.getBlockData().clone();
            Location location = block.getLocation();
            if (Config.getInstance().getIgnoredMaterials().contains(blockType)) continue;
            block.setMetadata("multi-broken", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)true));
            boolean broken = this.getPlayer().breakBlock(block);
            if (!broken) continue;
            if (multiBlock.getDrops() != null) {
                for (ItemStack drop : multiBlock.getDrops()) {
                    world.dropItemNaturally(location, drop);
                }
            }
            world.playSound(location, blockData.getSoundGroup().getBreakSound(), volume, 1.0f);
            if (!multiBlock.isVisible()) continue;
            particleBuilder.location(location.add(0.5, 0.5, 0.5)).data((Object)blockData).spawn();
        }
    }

    public void updateBlockAnimationPacket() {
        float breakSpeed = this.getBlock().getBreakSpeed(this.getPlayer());
        float destroySpeed = 1.0E-6f + 1.0f / breakSpeed;
        this.progressBroken += 1.0f / destroySpeed;
        this.progressBroken = Math.min(this.progressBroken, 1.0f);
        this.progressBroken = Math.max(this.progressBroken, 0.0f);
        this.writeStage(this.progressBroken);
    }

    public void writeStage(float stage) {
        this.writeStage(this.nearbyPlayers, stage);
    }

    public void writeStage(Collection<UUID> uuids, float stage) {
        Collection onlinePlayers = uuids.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).collect(Collectors.toList());
        for (MultiBlock multiBlock : this.multiBlocks) {
            if (multiBlock.getBlock().equals((Object)this.getBlock()) || !multiBlock.isVisible()) continue;
            multiBlock.writeStage(onlinePlayers, stage);
        }
    }

    public void checkPlayers() {
        Set<UUID> oldNearbyPlayers = this.nearbyPlayers;
        Location blockLoc = this.block.getLocation();
        Set<UUID> newNearbyPlayers = this.getNearbyPlayers(blockLoc);
        HashSet<UUID> departedPlayers = new HashSet<UUID>(oldNearbyPlayers);
        departedPlayers.removeAll(newNearbyPlayers);
        this.writeStage(departedPlayers, 0.0f);
        this.nearbyPlayers = newNearbyPlayers;
    }

    public void checkRemove() {
        List<MultiBlock> blocksToRemove = this.getMultiBlocks().stream().filter(MultiBlock::mismatchesType).toList();
        this.writeStage(0.0f);
        this.getMultiBlocks().removeAll(blocksToRemove);
    }

    public boolean isValid(EnumSet<Material> includedMaterials, EnumSet<Material> excludedMaterials) {
        Material mainBlockType = this.getBlock().getType();
        if (includedMaterials != null && !includedMaterials.isEmpty() && !includedMaterials.contains(mainBlockType)) {
            return false;
        }
        return excludedMaterials == null || excludedMaterials.isEmpty() || !excludedMaterials.contains(mainBlockType);
    }

    public void checkValid(float progressPerTick, EnumSet<Material> includedMaterials, EnumSet<Material> excludedMaterials) {
        if (includedMaterials != null && !includedMaterials.isEmpty()) {
            this.getMultiBlocks().removeIf(multiBlock -> !includedMaterials.contains(multiBlock.getBlock().getType()));
        }
        if (excludedMaterials != null && !excludedMaterials.isEmpty()) {
            this.getMultiBlocks().removeIf(multiBlock -> excludedMaterials.contains(multiBlock.getBlock().getType()));
        }
        this.getMultiBlocks().removeIf(multiBlock -> multiBlock.getBlock().getType().equals((Object)Material.AIR));
        boolean fairMode = Config.getInstance().isFairModeEnabled();
        if (!fairMode) {
            return;
        }
        ArrayList<MultiBlock> toRemove = new ArrayList<MultiBlock>();
        for (MultiBlock multiBlock2 : this.getMultiBlocks()) {
            float blockProgressPerTick = multiBlock2.getBlock().getBreakSpeed(this.getPlayer());
            if (progressPerTick == Float.POSITIVE_INFINITY && blockProgressPerTick < progressPerTick) {
                toRemove.add(multiBlock2);
                continue;
            }
            if (blockProgressPerTick != Float.POSITIVE_INFINITY) continue;
            multiBlock2.setVisible(false);
        }
        this.getMultiBlocks().removeAll(toRemove);
    }

    public void playParticles() {
        Vector finalOffset = new Vector(0.45, 0.45, 0.45);
        if (this.getPlayerDirection().getX() != 0.0) {
            finalOffset.setX(0.0);
        }
        if (this.getPlayerDirection().getY() != 0.0) {
            finalOffset.setY(0.0);
        }
        if (this.getPlayerDirection().getZ() != 0.0) {
            finalOffset.setZ(0.0);
        }
        ParticleBuilder particleBuilder = new ParticleBuilder(Particle.BLOCK_CRUMBLE).offset(finalOffset.getX(), finalOffset.getY(), finalOffset.getZ());
        Vector playerDirectionTimesHalf = this.playerDirection.clone().multiply(0.5001);
        for (MultiBlock multiBlock : this.getMultiBlocks()) {
            if (multiBlock.getBlock().equals((Object)this.getBlock()) || !multiBlock.isVisible()) continue;
            Block block1 = multiBlock.getBlock();
            BlockData blockData = block1.getBlockData();
            particleBuilder.location(block1.getLocation().add(0.5, 0.5, 0.5).add(playerDirectionTimesHalf)).data((Object)blockData).extra(0.2).spawn();
        }
    }

    public Set<UUID> getNearbyPlayers(Location blockLoc) {
        return blockLoc.getWorld().getNearbyPlayers(blockLoc, 64.0).stream().map(OfflinePlayer::getUniqueId).collect(Collectors.toSet());
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.playerUUID);
    }

    public List<Block> getBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (MultiBlock multiBlock : this.getMultiBlocks()) {
            blocks.add(multiBlock.getBlock());
        }
        return blocks;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getProgressTicks() {
        return this.progressTicks;
    }

    public List<MultiBlock> getMultiBlocks() {
        return this.multiBlocks;
    }

    public float getProgressBroken() {
        return this.progressBroken;
    }

    public Vector getPlayerDirection() {
        return this.playerDirection;
    }

    public boolean hasEnded() {
        return this.ended;
    }

    public void setProgressTicks(int progressTicks) {
        this.progressTicks = progressTicks;
    }

    public void setProgressBroken(float progressBroken) {
        this.progressBroken = progressBroken;
    }

    public String toString() {
        return "MultiBreak{p=" + String.valueOf(this.getPlayer()) + ", block=" + String.valueOf(this.block) + ", progressTicks=" + this.progressTicks + ", multiBlocks=" + String.valueOf(this.multiBlocks) + ", ended=" + this.ended + "}";
    }
}

