/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.figure.types.FigureType;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ConfigManager {
    private HashMap<String, Figure> configOptions;
    private HashMap<Material, String> materialOptions;
    private final List<Material> ignoredMaterials = new ArrayList<Material>();
    private final boolean[] options = new boolean[optionNames.length];
    private static final String[] optionNames = new String[]{"fair_mode", "legacy_mode"};

    public Inventory getMenu() {
        Inventory inventory = Bukkit.createInventory(null, (int)54, (Component)Component.text((String)"Configurations"));
        int index = 0;
        for (Map.Entry<String, Figure> entry : this.configOptions.entrySet()) {
            String name = entry.getKey();
            Figure figure = entry.getValue();
            ItemStack item = new ItemStack(Material.WRITABLE_BOOK);
            ItemMeta meta = item.getItemMeta();
            meta.displayName((Component)Component.text((String)name));
            meta.lore(figure.getLore());
            item.setItemMeta(meta);
            inventory.setItem(index, item);
            ++index;
        }
        return inventory;
    }

    public void save(FileConfiguration fileConfiguration) {
        for (int i = 0; i < this.options.length; ++i) {
            String string = optionNames[i];
            boolean option = this.options[i];
            fileConfiguration.set(string, (Object)option);
        }
        for (Map.Entry<String, Figure> entry : this.getConfigOptions().entrySet()) {
            String name = entry.getKey();
            String path = "config_options." + name;
            String figurePath = path + ".figure.";
            Figure figure = entry.getValue();
            fileConfiguration.set(figurePath + "type", (Object)figure.getFigureType().name());
            fileConfiguration.set(figurePath + "width", (Object)figure.getWidth());
            fileConfiguration.set(figurePath + "height", (Object)figure.getHeight());
            fileConfiguration.set(figurePath + "depth", (Object)figure.getDepth());
            fileConfiguration.set(figurePath + "width_rotation", (Object)figure.getRotationWidth());
            fileConfiguration.set(figurePath + "height_rotation", (Object)figure.getRotationHeight());
            fileConfiguration.set(figurePath + "depth_rotation", (Object)figure.getRotationDepth());
            fileConfiguration.set(figurePath + "width_offset", (Object)figure.getOffSetWidth());
            fileConfiguration.set(figurePath + "height_offset", (Object)figure.getOffSetHeight());
            fileConfiguration.set(figurePath + "depth_offset", (Object)figure.getOffSetDepth());
        }
        for (Map.Entry<String, Object> entry : this.materialOptions.entrySet()) {
            fileConfiguration.set("material_configs." + ((Material)entry.getKey()).name(), entry.getValue());
        }
        ArrayList materialNames = new ArrayList(this.ignoredMaterials.size());
        this.ignoredMaterials.forEach(material -> materialNames.add(material.toString()));
        fileConfiguration.set("ignored_materials", materialNames);
    }

    public boolean loadOptions(FileConfiguration fileConfiguration) {
        boolean save = false;
        int index = 0;
        for (String option : optionNames) {
            if (fileConfiguration.getKeys(false).contains(option)) {
                this.options[index] = fileConfiguration.getBoolean(option);
            } else {
                save = true;
                this.options[index] = false;
                fileConfiguration.set(option, (Object)false);
            }
            ++index;
        }
        return save;
    }

    public boolean load(FileConfiguration fileConfiguration) {
        this.configOptions = new HashMap();
        this.materialOptions = new HashMap();
        boolean save1 = this.loadOptions(fileConfiguration);
        this.loadMultiConfigs(fileConfiguration);
        this.loadMaterialConfigs(fileConfiguration);
        boolean save2 = this.loadIgnoredMaterials(fileConfiguration);
        return save1 || save2;
    }

    private void loadMultiConfigs(FileConfiguration fileConfiguration) {
        if (fileConfiguration.getKeys(false).contains("config_options")) {
            ConfigurationSection section = fileConfiguration.getConfigurationSection("config_options");
            for (String name : section.getKeys(false)) {
                ConfigurationSection section1 = section.getConfigurationSection(name).getConfigurationSection("figure");
                if (section1 == null) continue;
                FigureType figureType = FigureType.valueOf(section1.getString("type"));
                int width = section1.getInt("width");
                int height = section1.getInt("height");
                int depth = section1.getInt("depth");
                short width_rotation = (short)section1.getInt("width_rotation");
                short height_rotation = (short)section1.getInt("height_rotation");
                short depth_rotation = (short)section1.getInt("depth_rotation");
                int width_offset = section1.getInt("width_offset");
                int height_offset = section1.getInt("height_offset");
                int depth_offset = section1.getInt("depth_offset");
                Figure figure = figureType.build(width, height, depth);
                figure.setRotations(width_rotation, height_rotation, depth_rotation);
                figure.setOffsets(width_offset, height_offset, depth_offset);
                this.getConfigOptions().put(name, figure);
            }
        }
    }

    private void loadMaterialConfigs(FileConfiguration fileConfiguration) {
        if (fileConfiguration.getKeys(false).contains("material_configs")) {
            ConfigurationSection section = fileConfiguration.getConfigurationSection("material_configs");
            for (String itemtype : section.getKeys(false)) {
                String configOption = section.getString(itemtype);
                Material material = Material.valueOf((String)itemtype);
                this.getMaterialOptions().put(material, configOption);
            }
        }
    }

    private boolean loadIgnoredMaterials(FileConfiguration fileConfiguration) {
        if (fileConfiguration.getKeys(false).contains("ignored_materials")) {
            List materialNames = fileConfiguration.getStringList("ignored_materials");
            for (String matName : materialNames) {
                this.ignoredMaterials.add(Material.getMaterial((String)matName));
            }
        } else {
            ArrayList<String> ignoredMaterials = new ArrayList<String>();
            ignoredMaterials.add(Material.BEDROCK.toString());
            fileConfiguration.set("ignored_materials", ignoredMaterials);
            this.ignoredMaterials.add(Material.BEDROCK);
            return true;
        }
        return false;
    }

    public void updateDeleteConfig(FileConfiguration fileConfiguration, String name) {
        fileConfiguration.set("config_options." + name, null);
        ConfigurationSection section = fileConfiguration.getConfigurationSection("material_configs");
        if (section == null) {
            return;
        }
        for (String materialName : section.getKeys(false)) {
            if (!name.equals(section.get(materialName))) continue;
            section.set(materialName, null);
            this.getMaterialOptions().remove(Material.valueOf((String)materialName));
        }
    }

    public void updateDeleteMaterial(FileConfiguration fileConfiguration, Material material) {
        fileConfiguration.set("material_configs." + material.name(), null);
    }

    public HashMap<String, Figure> getConfigOptions() {
        return this.configOptions;
    }

    public boolean[] getOptions() {
        return this.options;
    }

    public HashMap<Material, String> getMaterialOptions() {
        return this.materialOptions;
    }

    public List<Material> getIgnoredMaterials() {
        return this.ignoredMaterials;
    }
}

