/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.figure;

import org.bukkit.util.Vector;

public class Matrix4x4 {
    private final double[][] matrix = new double[4][4];

    public Matrix4x4() {
        this.setIdentity();
    }

    public void setIdentity() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.matrix[i][j] = i == j ? 1.0 : 0.0;
            }
        }
    }

    public void setRotationX(double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        this.matrix[1][1] = cos;
        this.matrix[1][2] = -sin;
        this.matrix[2][1] = sin;
        this.matrix[2][2] = cos;
    }

    public void setRotationY(double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        this.matrix[0][0] = cos;
        this.matrix[0][2] = sin;
        this.matrix[2][0] = -sin;
        this.matrix[2][2] = cos;
    }

    public void setRotationZ(double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        this.matrix[0][0] = cos;
        this.matrix[0][1] = -sin;
        this.matrix[1][0] = sin;
        this.matrix[1][1] = cos;
    }

    public void transform(Vector vector) {
        double x = this.matrix[0][0] * vector.getX() + this.matrix[0][1] * vector.getY() + this.matrix[0][2] * vector.getZ();
        double y = this.matrix[1][0] * vector.getX() + this.matrix[1][1] * vector.getY() + this.matrix[1][2] * vector.getZ();
        double z = this.matrix[2][0] * vector.getX() + this.matrix[2][1] * vector.getY() + this.matrix[2][2] * vector.getZ();
        vector.setX(x);
        vector.setY(y);
        vector.setZ(z);
    }
}

