/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak;

import java.util.HashMap;
import java.util.UUID;
import me.vermulst.multibreak.Main;
import me.vermulst.multibreak.config.ConfigManager;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.item.FigureItemDataType;
import me.vermulst.multibreak.item.FigureItemInfo;
import me.vermulst.multibreak.multibreak.MultiBreak;
import me.vermulst.multibreak.multibreak.event.MultiBreakEndEvent;
import me.vermulst.multibreak.multibreak.event.MultiBreakStartEvent;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageAbortEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BreakManager
implements Listener {
    private final Main plugin;
    private final HashMap<UUID, Integer> multiBreakTask = new HashMap();
    private final HashMap<UUID, MultiBreak> multiBlockHashMap = new HashMap();

    public BreakManager(Main plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void armSwingEvent(PlayerAnimationEvent e) {
        boolean legacy_mode = this.plugin.getConfigManager().getOptions()[1];
        if (!legacy_mode) {
            return;
        }
        if (!e.getAnimationType().equals((Object)PlayerAnimationType.ARM_SWING)) {
            return;
        }
        Player p = e.getPlayer();
        if (p.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return;
        }
        MultiBreak multiBreak = this.getMultiBreak(p);
        if (multiBreak == null) {
            return;
        }
        Block blockMining = this.getTargetBlock(p);
        multiBreak.tick(this.getPlugin(), blockMining);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void multiBreakStop(BlockDamageAbortEvent e) {
        boolean legacy_mode = this.plugin.getConfigManager().getOptions()[1];
        if (legacy_mode) {
            return;
        }
        Player p = e.getPlayer();
        MultiBreak multiBreak = this.getMultiBreak(p);
        MultiBreakEndEvent event = new MultiBreakEndEvent(p, multiBreak, false);
        event.callEvent();
        if (multiBreak == null) {
            return;
        }
        this.end(p, multiBreak, false);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void breakBlockType(BlockBreakEvent e) {
        Player p = e.getPlayer();
        MultiBreak multiBreak = this.getMultiBreak(p);
        MultiBreakEndEvent event = new MultiBreakEndEvent(p, multiBreak, true);
        event.callEvent();
        if (event.isCancelled()) {
            return;
        }
        if (event.getMultiBreak() == null) {
            return;
        }
        this.end(p, event.getMultiBreak(), true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void multiBreakStart(BlockDamageEvent e) {
        boolean legacy_mode = this.plugin.getConfigManager().getOptions()[1];
        if (legacy_mode) {
            return;
        }
        this.scheduleMultiBreak(e.getPlayer());
    }

    public void scheduleMultiBreak(final Player p) {
        new BukkitRunnable(){

            public void run() {
                final MultiBreak multiBreak = BreakManager.this.getMultiBreak(p);
                if (multiBreak == null) {
                    return;
                }
                int taskID = new BukkitRunnable(){

                    public void run() {
                        multiBreak.tick();
                    }
                }.runTaskTimer((Plugin)BreakManager.this.getPlugin(), 0L, 1L).getTaskId();
                BreakManager.this.getMultiBreakTask().put(p.getUniqueId(), taskID);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    public void end(Player p, MultiBreak multiBreak, boolean finished) {
        UUID uuid = p.getUniqueId();
        multiBreak.end(finished);
        this.getMultiBlockHashMap().remove(uuid);
        if (!this.getMultiBreakTask().containsKey(uuid)) {
            return;
        }
        Bukkit.getScheduler().cancelTask(this.getMultiBreakTask().get(uuid).intValue());
    }

    public MultiBreak getMultiBreak(Player p) {
        MultiBreak multiBreak;
        if (p.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return null;
        }
        if (this.multiBlockHashMap.containsKey(p.getUniqueId()) && !(multiBreak = this.multiBlockHashMap.get(p.getUniqueId())).hasEnded()) {
            return multiBreak;
        }
        ItemStack tool = p.getInventory().getItemInMainHand();
        Figure figure = this.getFigure(tool);
        BlockFace blockFace = this.getBlockFace(p);
        Block blockMining = this.getTargetBlock(p);
        boolean fair_mode = this.plugin.getConfigManager().getOptions()[0];
        MultiBreak multiBreak2 = new MultiBreak(p, blockMining, figure, blockFace.getDirection(), fair_mode);
        MultiBreakStartEvent event = new MultiBreakStartEvent(p, multiBreak2, blockMining, blockFace.getDirection(), fair_mode);
        if (!event.callEvent()) {
            return null;
        }
        MultiBreak multiBreak1 = event.getMultiBreak();
        this.multiBlockHashMap.put(p.getUniqueId(), multiBreak1);
        return multiBreak1;
    }

    public Figure getFigure(ItemStack tool) {
        if (tool.getItemMeta() == null) {
            return null;
        }
        FigureItemInfo figureItemInfo = this.getFigureItemInfo(tool);
        if (figureItemInfo == null) {
            Material material = tool.getType();
            ConfigManager configManager = this.getPlugin().getConfigManager();
            if (configManager.getMaterialOptions().containsKey(material)) {
                String configOptionName = configManager.getMaterialOptions().get(material);
                return configManager.getConfigOptions().get(configOptionName);
            }
            return null;
        }
        return figureItemInfo.figure();
    }

    public FigureItemInfo getFigureItemInfo(ItemStack item) {
        FigureItemDataType figureItemDataType = new FigureItemDataType((Plugin)this.getPlugin());
        return figureItemDataType.get(item);
    }

    public Block getTargetBlock(Player p) {
        return p.getTargetBlockExact(10);
    }

    public BlockFace getBlockFace(Player p) {
        return p.getTargetBlockFace(10);
    }

    public Main getPlugin() {
        return this.plugin;
    }

    public HashMap<UUID, Integer> getMultiBreakTask() {
        return this.multiBreakTask;
    }

    public HashMap<UUID, MultiBreak> getMultiBlockHashMap() {
        return this.multiBlockHashMap;
    }
}

