/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.figure.types;

import java.util.HashSet;
import java.util.Set;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.figure.types.FigureType;
import org.bukkit.util.Vector;

public class FigureLinear
extends Figure {
    public FigureLinear(int width, int height, int depth) {
        super(width, height, depth);
    }

    @Override
    public Set<Vector> getVectors(boolean rotated) {
        HashSet<Vector> vectors = new HashSet<Vector>();
        int[] widthBound = this.getBoundPair(this.getWidth(), this.getOffSetWidth());
        int[] heightBound = this.getBoundPair(this.getHeight(), this.getOffSetHeight());
        int[] depthBound = this.getBoundPair(this.getDepth(), this.getOffSetDepth());
        if (rotated) {
            double step = 0.3;
            for (double width = (double)widthBound[0]; width <= (double)widthBound[1]; width += step) {
                for (double height = (double)heightBound[0]; height <= (double)heightBound[1]; height += step) {
                    for (double depth = (double)depthBound[0]; depth <= (double)depthBound[1]; depth += step) {
                        Vector vector = new Vector(width, height, depth);
                        vectors.add(vector);
                    }
                }
            }
        } else {
            for (int width = widthBound[0]; width <= widthBound[1]; ++width) {
                for (int height = heightBound[0]; height <= heightBound[1]; ++height) {
                    for (int depth = depthBound[0]; depth <= depthBound[1]; ++depth) {
                        vectors.add(new Vector(width, height, depth));
                    }
                }
            }
        }
        return vectors;
    }

    public int[] getBoundPair(int length, int offSetRight) {
        double bound = (double)(length - 1) / 2.0;
        int lowerBound = (int)Math.ceil(bound);
        int higherBound = (int)Math.floor(bound);
        return new int[]{-lowerBound + offSetRight, higherBound + offSetRight};
    }

    @Override
    public FigureType getFigureType() {
        return FigureType.LINEAR;
    }
}

