/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak;

import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class MultiBlock {
    private final Block block;
    private boolean isVisible;
    private final Material type;
    private final int sourceID;
    private volatile int lastStage = 0;
    private static final BlockFace[] cartesianBlockFaces = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};

    public MultiBlock(Block block, int sourceID) {
        this.block = block;
        this.type = block.getType();
        this.isVisible = this.initVisibility(block);
        this.sourceID = sourceID;
    }

    public boolean initVisibility(Block b) {
        for (BlockFace face : cartesianBlockFaces) {
            Block adjacent = b.getRelative(face);
            if (adjacent.isEmpty() || adjacent.isLiquid() && adjacent.getType() != Material.POWDER_SNOW) {
                return true;
            }
            if (adjacent.getType().isOccluding()) continue;
            return true;
        }
        return false;
    }

    public Location getLocation() {
        return this.block.getLocation();
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiBlock that = (MultiBlock)o;
        return this.isVisible == that.isVisible && Objects.equals(this.block, that.block);
    }

    public int hashCode() {
        return Objects.hash(this.block, this.isVisible);
    }

    public Material getType() {
        return this.type;
    }

    public int getSourceID() {
        return this.sourceID;
    }

    public int getLastStage() {
        return this.lastStage;
    }

    public void setLastStage(int lastStage) {
        this.lastStage = lastStage;
    }
}

