/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import me.vermulst.multibreak.commands.MultiBreakCommand;
import me.vermulst.multibreak.commands.MultiBreakTabCompleter;
import me.vermulst.multibreak.commands.MultiConfigCommand;
import me.vermulst.multibreak.commands.MultiConfigTabCompleter;
import me.vermulst.multibreak.config.ConfigManager;
import me.vermulst.multibreak.dependencies.bstats.bukkit.Metrics;
import me.vermulst.multibreak.multibreak.BreakManager;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin {
    private ConfigManager configManager;
    private final Set<Material> nonOccluding = Arrays.stream(Material.values()).filter(material -> !material.isOccluding()).collect(Collectors.toSet());

    public void onEnable() {
        int pluginId = 20516;
        new Metrics(this, pluginId);
        this.configManager = new ConfigManager();
        this.getConfigManager().load(this.getConfig());
        this.getServer().getPluginManager().registerEvents((Listener)new BreakManager(this), (Plugin)this);
        PluginCommand multibreakCommand = this.getServer().getPluginCommand("multibreak");
        multibreakCommand.setExecutor((CommandExecutor)new MultiBreakCommand((Plugin)this));
        multibreakCommand.setTabCompleter((TabCompleter)new MultiBreakTabCompleter());
        PluginCommand multiconfigCommand = this.getServer().getPluginCommand("multiconfig");
        multiconfigCommand.setExecutor((CommandExecutor)new MultiConfigCommand(this));
        multiconfigCommand.setTabCompleter((TabCompleter)new MultiConfigTabCompleter(this.getConfigManager()));
    }

    public void onDisable() {
        this.getConfigManager().save(this.getConfig());
        this.saveConfig();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public Set<Material> getNonOccluding() {
        return this.nonOccluding;
    }
}

