/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.item;

import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.figure.types.FigureType;
import me.vermulst.multibreak.item.FigureItemInfo;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class FigureItemDataType
implements PersistentDataType<PersistentDataContainer, FigureItemInfo> {
    private final Plugin javaPlugin;

    public FigureItemDataType(Plugin javaPlugin) {
        this.javaPlugin = javaPlugin;
    }

    public ItemStack set(ItemStack itemStack, FigureItemInfo figureItemInfo) {
        NamespacedKey key = new NamespacedKey(this.javaPlugin, "figure_info");
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer customItemTagContainer = itemMeta.getPersistentDataContainer();
        customItemTagContainer.set(key, (PersistentDataType)this, (Object)figureItemInfo);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public FigureItemInfo get(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        NamespacedKey key = new NamespacedKey(this.javaPlugin, "figure_info");
        PersistentDataContainer customItemTagContainer = meta.getPersistentDataContainer();
        return (FigureItemInfo)customItemTagContainer.get(key, (PersistentDataType)this);
    }

    public ItemStack remove(ItemStack itemStack) {
        NamespacedKey key = new NamespacedKey(this.javaPlugin, "figure_info");
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer customItemTagContainer = itemMeta.getPersistentDataContainer();
        customItemTagContainer.remove(key);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @NotNull
    public Class<PersistentDataContainer> getPrimitiveType() {
        return PersistentDataContainer.class;
    }

    @NotNull
    public Class<FigureItemInfo> getComplexType() {
        return FigureItemInfo.class;
    }

    @NotNull
    public PersistentDataContainer toPrimitive(FigureItemInfo figureInfo, PersistentDataAdapterContext persistentDataAdapterContext) {
        PersistentDataContainer persistentDataContainer = persistentDataAdapterContext.newPersistentDataContainer();
        persistentDataContainer.set(this.key("width"), PersistentDataType.INTEGER, (Object)figureInfo.figure().getWidth());
        persistentDataContainer.set(this.key("height"), PersistentDataType.INTEGER, (Object)figureInfo.figure().getHeight());
        persistentDataContainer.set(this.key("depth"), PersistentDataType.INTEGER, (Object)figureInfo.figure().getDepth());
        if (figureInfo.figure().getRotationWidth() != 0) {
            persistentDataContainer.set(this.key("widthR"), PersistentDataType.SHORT, (Object)figureInfo.figure().getRotationWidth());
        }
        if (figureInfo.figure().getRotationHeight() != 0) {
            persistentDataContainer.set(this.key("heightR"), PersistentDataType.SHORT, (Object)figureInfo.figure().getRotationHeight());
        }
        if (figureInfo.figure().getRotationDepth() != 0) {
            persistentDataContainer.set(this.key("depthR"), PersistentDataType.SHORT, (Object)figureInfo.figure().getRotationDepth());
        }
        if (figureInfo.figure().getOffSetWidth() != 0) {
            persistentDataContainer.set(this.key("widthO"), PersistentDataType.INTEGER, (Object)figureInfo.figure().getOffSetWidth());
        }
        if (figureInfo.figure().getOffSetHeight() != 0) {
            persistentDataContainer.set(this.key("heightO"), PersistentDataType.INTEGER, (Object)figureInfo.figure().getOffSetHeight());
        }
        if (figureInfo.figure().getOffSetDepth() != 0) {
            persistentDataContainer.set(this.key("depthO"), PersistentDataType.INTEGER, (Object)figureInfo.figure().getOffSetDepth());
        }
        persistentDataContainer.set(this.key("type_id"), PersistentDataType.INTEGER, (Object)figureInfo.figure().getFigureType().ordinal());
        return persistentDataContainer;
    }

    @NotNull
    public FigureItemInfo fromPrimitive(PersistentDataContainer persistentDataContainer, @NotNull PersistentDataAdapterContext persistentDataAdapterContext) {
        int width = (Integer)persistentDataContainer.getOrDefault(this.key("width"), PersistentDataType.INTEGER, (Object)3);
        int height = (Integer)persistentDataContainer.getOrDefault(this.key("height"), PersistentDataType.INTEGER, (Object)3);
        int depth = (Integer)persistentDataContainer.getOrDefault(this.key("depth"), PersistentDataType.INTEGER, (Object)1);
        int figureTypeOrdinal = (Integer)persistentDataContainer.getOrDefault(this.key("type_id"), PersistentDataType.INTEGER, (Object)0);
        FigureType figureType = FigureType.values()[figureTypeOrdinal];
        Figure figure = figureType.build(width, height, depth);
        short widthR = (Short)persistentDataContainer.getOrDefault(this.key("widthR"), PersistentDataType.SHORT, (Object)0);
        short heightR = (Short)persistentDataContainer.getOrDefault(this.key("heightR"), PersistentDataType.SHORT, (Object)0);
        short depthR = (Short)persistentDataContainer.getOrDefault(this.key("depthR"), PersistentDataType.SHORT, (Object)0);
        int widthO = (Integer)persistentDataContainer.getOrDefault(this.key("widthO"), PersistentDataType.INTEGER, (Object)0);
        int heightO = (Integer)persistentDataContainer.getOrDefault(this.key("heightO"), PersistentDataType.INTEGER, (Object)0);
        int depthO = (Integer)persistentDataContainer.getOrDefault(this.key("depthO"), PersistentDataType.INTEGER, (Object)0);
        figure.setRotations(widthR, heightR, depthR);
        figure.setOffsets(widthO, heightO, depthO);
        return new FigureItemInfo(figure);
    }

    private NamespacedKey key(String key) {
        return new NamespacedKey(this.javaPlugin, key);
    }

    private int getOrDefault(Integer integer, int defaultValue) {
        return integer != null ? integer : defaultValue;
    }

    private boolean fromByte(Byte byteValue, boolean defaultValue) {
        return byteValue != null ? byteValue == 1 : defaultValue;
    }
}

