/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak;

import com.destroystokyo.paper.ParticleBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import me.vermulst.multibreak.CompassDirection;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.figure.Matrix4x4;
import me.vermulst.multibreak.figure.VectorTransformer;
import me.vermulst.multibreak.multibreak.MultiBlock;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class MultiBreak {
    private final Player p;
    private final Block block;
    private int progressTicks;
    private ArrayList<MultiBlock> multiBlocks = new ArrayList();
    private final int destroySpeedInTicks;

    public MultiBreak(Player p, Block block, Figure figure, Vector playerDirection) {
        this.p = p;
        this.block = block;
        this.initBlocks(figure, playerDirection);
        float breakSpeed = this.getBlock().getBreakSpeed(this.getPlayer());
        this.checkValid(breakSpeed);
        this.destroySpeedInTicks = (int)(1.0E-4 + (double)(1.0f / breakSpeed));
    }

    public void checkValid(float breakSpeed) {
        this.getMultiBlocks().removeIf(multiBlock -> multiBlock.getBlock().getType().equals((Object)Material.AIR));
        this.getMultiBlocks().removeIf(multiBlock -> multiBlock.getBlock().getBreakSpeed(this.getPlayer()) < breakSpeed);
    }

    public void initBlocks(Figure figure, Vector playerDirection) {
        Object rotatedVectors;
        this.multiBlocks = new ArrayList();
        CompassDirection compassDirection = CompassDirection.getCompassDir(this.getPlayer().getLocation());
        VectorTransformer vectorTransformer = new VectorTransformer(playerDirection, compassDirection);
        boolean rotated = (double)figure.getRotationWidth() != 0.0 || (double)figure.getRotationHeight() != 0.0 || (double)figure.getRotationDepth() != 0.0;
        Object blockVectors = figure.getVectors(rotated);
        if (rotated) {
            rotatedVectors = new HashSet();
            Matrix4x4 rotationMatrix = new Matrix4x4();
            rotationMatrix.setRotationX((double)figure.getRotationWidth() * (Math.PI / 180));
            rotationMatrix.setRotationY((double)figure.getRotationHeight() * (Math.PI / 180));
            rotationMatrix.setRotationZ((double)figure.getRotationDepth() * (Math.PI / 180));
            Iterator<Vector> iterator = ((HashSet)blockVectors).iterator();
            while (iterator.hasNext()) {
                Vector vector = iterator.next();
                rotationMatrix.transform(vector);
                vector.setX((float)Math.round(vector.getX()));
                vector.setY((float)Math.round(vector.getY()));
                vector.setZ((float)Math.round(vector.getZ()));
                ((HashSet)rotatedVectors).add(new Vector((float)Math.round(vector.getX()), (float)Math.round(vector.getY()), (float)Math.round(vector.getZ())));
            }
            blockVectors = rotatedVectors;
        }
        rotatedVectors = ((HashSet)blockVectors).iterator();
        while (rotatedVectors.hasNext()) {
            Vector vector = (Vector)rotatedVectors.next();
            vectorTransformer.rotateVector(vector);
        }
        Location loc = this.getBlock().getLocation();
        Iterator<Vector> iterator = ((HashSet)blockVectors).iterator();
        while (iterator.hasNext()) {
            Vector vector = iterator.next();
            if (vector.equals((Object)new Vector(0, 0, 0))) continue;
            Block block1 = loc.clone().add(vector).getBlock();
            MultiBlock multiBlock = new MultiBlock(block1);
            this.getMultiBlocks().add(multiBlock);
        }
    }

    public void tick() {
        ++this.progressTicks;
        this.updateAnimations(this.progressTicks % 2 == 0);
    }

    public void end(boolean finished) {
        for (MultiBlock multiBlock : this.getMultiBlocks()) {
            multiBlock.writeStage(-1);
        }
        if (!finished) {
            return;
        }
        ParticleBuilder particleBuilder = new ParticleBuilder(Particle.ITEM_CRACK).count(4).offset(1.0, 0.1, 0.1).extra(0.1);
        World world = this.getBlock().getWorld();
        int size = this.getMultiBlocks().size() - 1;
        float volume = (float)(1.0 / Math.log((double)(size + 1) * Math.E));
        ItemStack tool = this.getPlayer().getInventory().getItemInMainHand();
        for (MultiBlock multiBlock : this.getMultiBlocks()) {
            Block block = multiBlock.getBlock();
            for (ItemStack drop : block.getDrops(tool)) {
                world.dropItemNaturally(block.getLocation(), drop);
            }
            if (multiBlock.hasAdjacentAir()) {
                particleBuilder.data((Object)new ItemStack(block.getType())).location(block.getLocation().add(0.5, 0.0, 0.5)).spawn();
            }
            world.playSound(block.getLocation(), block.getBlockData().getSoundGroup().getBreakSound(), volume, 1.0f);
            block.setType(Material.AIR);
        }
    }

    public void updateAnimations(boolean particles) {
        ParticleBuilder particleBuilder = new ParticleBuilder(Particle.BLOCK_CRACK).offset(0.375, 0.0, 0.375);
        HashMap<Material, BlockData> blockDataHashMap = new HashMap<Material, BlockData>();
        for (MultiBlock multiBlock : this.getMultiBlocks()) {
            if (!multiBlock.hasAdjacentAir()) continue;
            Block block1 = multiBlock.getBlock();
            if (!particles) continue;
            BlockData blockData = blockDataHashMap.computeIfAbsent(block1.getType(), data -> block1.getType().createBlockData());
            particleBuilder.location(block1.getLocation().add(0.5, 1.0, 0.5)).data((Object)blockData).spawn();
        }
        this.updateBlockAnimationPacket();
    }

    public void updateBlockAnimationPacket() {
        double progress = (double)this.getProgressTicks() / (double)this.getDestroySpeedInTicks();
        int stage = (int)(progress * 9.0);
        for (MultiBlock multiBlock : this.getMultiBlocks()) {
            if (!multiBlock.hasAdjacentAir()) continue;
            multiBlock.writeStage(stage);
        }
    }

    public Player getPlayer() {
        return this.p;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getProgressTicks() {
        return this.progressTicks;
    }

    public ArrayList<MultiBlock> getMultiBlocks() {
        return this.multiBlocks;
    }

    public int getDestroySpeedInTicks() {
        return this.destroySpeedInTicks;
    }
}

