/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom;

import fr.devsylone.fallenkingdom.bstats.bukkit.Metrics;
import fr.devsylone.fallenkingdom.bstats.charts.SimplePie;
import fr.devsylone.fallenkingdom.bstats.charts.SingleLineChart;
import fr.devsylone.fallenkingdom.commands.FkAsyncCommandExecutor;
import fr.devsylone.fallenkingdom.commands.FkAsyncRegisteredCommandExecutor;
import fr.devsylone.fallenkingdom.commands.FkCommandExecutor;
import fr.devsylone.fallenkingdom.commands.FkLifecycleRegisteredExecutor;
import fr.devsylone.fallenkingdom.commands.brigadier.BrigadierSpigotManager;
import fr.devsylone.fallenkingdom.display.GlobalDisplayService;
import fr.devsylone.fallenkingdom.game.Game;
import fr.devsylone.fallenkingdom.manager.CommandManager;
import fr.devsylone.fallenkingdom.manager.LanguageManager;
import fr.devsylone.fallenkingdom.manager.ListenersManager;
import fr.devsylone.fallenkingdom.manager.SaveablesManager;
import fr.devsylone.fallenkingdom.manager.TipsManager;
import fr.devsylone.fallenkingdom.manager.WorldManager;
import fr.devsylone.fallenkingdom.manager.saveable.DeepPauseManager;
import fr.devsylone.fallenkingdom.manager.saveable.PlayerManager;
import fr.devsylone.fallenkingdom.manager.saveable.PortalsManager;
import fr.devsylone.fallenkingdom.manager.saveable.ScoreboardManager;
import fr.devsylone.fallenkingdom.manager.saveable.StarterInventoryManager;
import fr.devsylone.fallenkingdom.pause.PauseRestorer;
import fr.devsylone.fallenkingdom.players.FkPlayer;
import fr.devsylone.fallenkingdom.scoreboard.PlaceHolder;
import fr.devsylone.fallenkingdom.scoreboard.PlaceHolderExpansion;
import fr.devsylone.fallenkingdom.updater.GitHubAssetInfo;
import fr.devsylone.fallenkingdom.updater.UpdateChecker;
import fr.devsylone.fallenkingdom.utils.FkConfig;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.version.FkSound;
import fr.devsylone.fallenkingdom.version.LuckPermsContext;
import fr.devsylone.fallenkingdom.version.Version;
import fr.devsylone.fkpi.FkPI;
import fr.devsylone.fkpi.rules.Rule;
import fr.devsylone.fkpi.teams.Team;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class Fk
extends JavaPlugin {
    protected Game game;
    protected CommandManager commandManager;
    protected PlayerManager playerManager;
    protected WorldManager worldManager;
    protected PauseRestorer pauseRestorer;
    protected StarterInventoryManager starterInventoryManager;
    protected ScoreboardManager scoreboardManager;
    protected GlobalDisplayService displayService;
    protected DeepPauseManager deepPauseManager;
    protected TipsManager tipsManager;
    protected SaveablesManager saveableManager;
    protected PortalsManager portalsManager;
    protected LanguageManager languageManager;
    protected static Fk instance;
    protected FkPI fkPI;
    private final List<BaseComponent[]> onConnectWarnings = new ArrayList<BaseComponent[]>();
    private String pluginError = "";
    private String previousVersion = this.getDescription().getVersion();

    public Fk() {
        instance = this;
    }

    public void onEnable() {
        try {
            this.onEnable0();
        }
        catch (Throwable throwable) {
            this.pluginError = throwable.getMessage();
            throw throwable;
        }
    }

    public void onEnable0() {
        ListenersManager.registerListeners(this);
        this.languageManager = new LanguageManager(this);
        if (!this.check()) {
            return;
        }
        this.worldManager = new WorldManager(this);
        this.fkPI = new FkPI();
        PluginCommand command = Objects.requireNonNull(this.getCommand("fk"), "Unable to register /fk command");
        this.commandManager = Version.isAsyncTabCompleteSupported() ? (Version.isAsyncPlayerSendCommandsEventSupported() ? (Version.classExists("io.papermc.paper.command.brigadier.Commands") ? new FkLifecycleRegisteredExecutor(this, command) : new FkAsyncRegisteredCommandExecutor(this, command)) : new FkAsyncCommandExecutor(this, command)) : new FkCommandExecutor(this, command);
        if (Version.isBrigadierSupported() && !Version.isAsyncPlayerSendCommandsEventSupported()) {
            new BrigadierSpigotManager((Plugin)this, this.commandManager, command);
        }
        this.displayService = new GlobalDisplayService();
        this.playerManager = new PlayerManager(this.displayService);
        this.pauseRestorer = new PauseRestorer();
        this.starterInventoryManager = new StarterInventoryManager();
        this.scoreboardManager = new ScoreboardManager();
        this.deepPauseManager = new DeepPauseManager();
        this.tipsManager = new TipsManager();
        this.tipsManager.startBroadcasts();
        this.portalsManager = new PortalsManager();
        this.game = new Game();
        this.saveableManager = new SaveablesManager(this);
        this.saveableManager.update();
        if (!this.saveableManager.getFileConfiguration("save.yml").contains("last_version")) {
            this.saveableManager.getFileConfiguration("save.yml").set("last_version", "2.5.0");
        }
        this.previousVersion = this.saveableManager.getFileConfiguration("save.yml").getString("last_version");
        this.saveableManager.loadAll();
        this.game.updateDayDuration(this.displayService);
        this.saveDefaultConfig();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceHolderExpansion().register();
        }
        try {
            Class.forName("net.luckperms.api.context.ContextCalculator");
            new LuckPermsContext(this);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (this.fkPI.getRulesManager().getRulesList().containsKey(Rule.ETERNAL_DAY) && this.fkPI.getRulesManager().getRule(Rule.ETERNAL_DAY).booleanValue()) {
            for (World w : Bukkit.getWorlds()) {
                if (!Fk.getInstance().getWorldManager().isAffected(w)) continue;
                w.setGameRuleValue("doDaylightCycle", "false");
                w.setTime(6000L);
            }
        }
        if (this.fkPI.getRulesManager().getRule(Rule.HEALTH_BELOW_NAME).booleanValue()) {
            this.fkPI.getTeamManager().nametag().createHealthObjective();
        }
        try {
            this.metrics();
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
        }
        UpdateChecker updater = new UpdateChecker(this);
        if (updater.getCurrentVersion().isRelease()) {
            updater.runTaskAsynchronously((Plugin)this);
        }
        this.getServer().getScheduler().runTaskTimer((Plugin)this, this.saveableManager::delayedSaveAll, 6000L, 6000L);
    }

    public void onDisable() {
        for (Player player : this.getServer().getOnlinePlayers()) {
            FkPlayer fkPlayer = this.playerManager.getPlayerIfExist(player);
            if (fkPlayer == null) continue;
            this.displayService.hide(player, fkPlayer);
        }
        this.fkPI.teardown();
        this.saveableManager.delayedSaveAll();
        FkConfig.awaitSaveEnd();
        if (this.game.isPaused()) {
            this.getDeepPauseManager().unprotectItems();
            this.getDeepPauseManager().resetAIs();
        }
    }

    public static void broadcast(String message, String prefix, FkSound sound) {
        if (message == null || message.isEmpty()) {
            return;
        }
        message = "\u00a7r" + message;
        for (FkPlayer p : Fk.getInstance().getPlayerManager().getConnectedPlayers()) {
            p.sendMessage(message, prefix, sound);
        }
    }

    public static void broadcast(String message, String prefix) {
        Fk.broadcast(message, prefix, null);
    }

    public static void broadcast(String message, FkSound sound) {
        Fk.broadcast(message, "", sound);
    }

    public static void broadcast(String message) {
        Fk.broadcast(message, "", null);
    }

    public void addError(String s) {
        this.pluginError = s;
    }

    public void reset() {
        Bukkit.getScheduler().cancelTasks((Plugin)instance);
        this.fkPI.reset();
        this.game = new Game();
        for (FkPlayer p : this.getPlayerManager().getConnectedPlayers()) {
            p.getScoreboard().remove();
        }
        this.playerManager = new PlayerManager(this.displayService);
        this.portalsManager = new PortalsManager();
        this.deepPauseManager.unprotectItems();
        this.deepPauseManager.resetAIs();
        this.saveableManager.reset();
        this.pauseRestorer = new PauseRestorer();
        this.displayService.loadNullable(null);
        this.displayService.updateAll(new PlaceHolder[0]);
        this.saveableManager = new SaveablesManager(this);
    }

    public void stop() {
        Bukkit.getScheduler().cancelTasks((Plugin)instance);
        this.tipsManager.cancelBroadcasts();
        this.tipsManager.startBroadcasts();
        this.game.stop();
        this.deepPauseManager.resetAIs();
        this.deepPauseManager.unprotectItems();
        for (FkPlayer p : this.getPlayerManager().players()) {
            p.clearDeaths();
            p.clearKills();
        }
        for (Team team : this.fkPI.getTeamManager().getTeams()) {
            if (team.getBase() == null) continue;
            team.getBase().resetChestRoom();
        }
        this.displayService.hideAll();
        this.displayService.updateAll(new PlaceHolder[0]);
    }

    private boolean check() {
        if (this.getConfig().get("Charged_creepers") != null) {
            this.addError(Messages.CONSOLE_CHARGED_CREEPERS_NOT_USE.getMessage());
        }
        if (!Version.hasSpigotApi()) {
            this.addError("Le serveur n'est pas support\u00e9 par le plugin. Seuls les serveurs bas\u00e9s sur Spigot sont support\u00e9s.\nThe server is not supported by the plugin. Only Spigot based servers are supported.\nDer Server wird vom Plugin nicht unterst\u00fctzt. Es werden nur Spigot-basierte Server unterst\u00fctzt.");
        }
        if (Version.isTooOldApi()) {
            this.addError("\u00a7rLa version du serveur n'est pas compatible avec le plugin,\nmerci d'utiliser au minimum la version \u00a7l\u00a7n1.8.3 de Spigot.\n\n\u00a7rThe server version isn't compatible with the plugin,\nplease use at least the \u00a7l\u00a7n1.8.3 version of Spigot.\n\nDie Version des Servers ist nicht mit dem Plugin kompatibel. Bitte benutzen Sie mindestens die \u00a7l\u00a7nSpigot-Version 1.8.3.");
        }
        if (!this.pluginError.isEmpty()) {
            this.getLogger().severe("------------------------------------------");
            this.getLogger().warning(this.pluginError);
            this.getLogger().severe("------------------------------------------");
            this.addOnConnectWarning(this.pluginError);
        }
        return this.pluginError.isEmpty();
    }

    private void metrics() throws NoClassDefFoundError {
        Metrics metrics = new Metrics((Plugin)this, 6738);
        metrics.addCustomChart(new SingleLineChart("server_running_1-8_version", () -> !Version.VersionType.V1_9_V1_12.isHigherOrEqual() ? 1 : 0));
        metrics.addCustomChart(new SimplePie("lang_used", () -> this.languageManager.getLocale().getLanguage()));
    }

    public void addOnConnectWarning(String warning) {
        this.onConnectWarnings.add(TextComponent.fromLegacyText((String)warning));
    }

    public void addOnConnectWarning(BaseComponent[] warning) {
        this.onConnectWarnings.add(warning);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean updatePlugin(@NotNull GitHubAssetInfo assetInfo) {
        try (ReadableByteChannel readableByteChannel = Channels.newChannel(new URI(assetInfo.browserDownloadUrl()).toURL().openStream());){
            FileOutputStream fileOutputStream;
            block16: {
                boolean bl;
                fileOutputStream = new FileOutputStream(this.getDataFolder().getParentFile().getName() + '/' + assetInfo.name());
                try {
                    fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                    File parent = new File(this.getFile().getParentFile().getParentFile(), this.getFile().getName());
                    if (!parent.exists()) break block16;
                    bl = parent.delete() && this.getFile().delete();
                }
                catch (Throwable throwable) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                fileOutputStream.close();
                return bl;
            }
            boolean bl = this.getFile().delete();
            fileOutputStream.close();
            return bl;
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, "Unable to download the update.", ex);
        }
        catch (URISyntaxException ex) {
            this.getLogger().log(Level.SEVERE, "Invalid URL to download from.", ex);
        }
        return false;
    }

    @NotNull
    public Path getPluginFolder() {
        return this.getDataFolder().toPath();
    }

    @NotNull
    public Path getRunDir() {
        File pluginsDir = this.getDataFolder().getParentFile().getAbsoluteFile();
        File runDir = pluginsDir.getParentFile().getAbsoluteFile();
        return runDir.toPath();
    }

    @NotNull
    public static Fk getInstance() {
        return instance;
    }

    @NotNull
    public Game getGame() {
        return this.game;
    }

    @NotNull
    public FkPI getFkPI() {
        return this.fkPI;
    }

    @NotNull
    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    @NotNull
    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    @NotNull
    public WorldManager getWorldManager() {
        return this.worldManager;
    }

    @NotNull
    public PauseRestorer getPauseRestorer() {
        return this.pauseRestorer;
    }

    @NotNull
    public StarterInventoryManager getStarterInventoryManager() {
        return this.starterInventoryManager;
    }

    @NotNull
    public ScoreboardManager getScoreboardManager() {
        return this.scoreboardManager;
    }

    @NotNull
    public GlobalDisplayService getDisplayService() {
        return this.displayService;
    }

    @NotNull
    public DeepPauseManager getDeepPauseManager() {
        return this.deepPauseManager;
    }

    @NotNull
    public TipsManager getTipsManager() {
        return this.tipsManager;
    }

    @NotNull
    public SaveablesManager getSaveableManager() {
        return this.saveableManager;
    }

    @NotNull
    public PortalsManager getPortalsManager() {
        return this.portalsManager;
    }

    @NotNull
    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    @NotNull
    public String getPluginError() {
        return this.pluginError;
    }

    public List<BaseComponent[]> getOnConnectWarnings() {
        return this.onConnectWarnings;
    }
}

