/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands;

import fr.devsylone.fallenkingdom.display.ScoreboardDisplayService;
import fr.devsylone.fallenkingdom.exception.ArgumentParseException;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.version.Version;
import fr.devsylone.fkpi.FkPI;
import fr.devsylone.fkpi.lockedchests.LockedChest;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ArgumentParser {
    public static List<String> parsePlayers(CommandSender sender, String players) {
        if (!players.startsWith("@")) {
            return Collections.singletonList(players);
        }
        return ArgumentParser.parseEntities(sender, players).stream().filter(entity -> entity instanceof Player).map(CommandSender::getName).collect(Collectors.toList());
    }

    public static List<Entity> parseEntities(CommandSender sender, String selector) {
        if (Version.VersionType.V1_13.isHigherOrEqual() && selector.startsWith("@")) {
            try {
                List affected = Bukkit.getServer().selectEntities(sender, selector);
                if (affected.isEmpty()) {
                    TranslatableComponent notFound = new TranslatableComponent("argument.entity.notfound.entity", new Object[0]);
                    notFound.setColor(ChatColor.RED);
                    sender.spigot().sendMessage((BaseComponent)notFound);
                }
                return affected;
            }
            catch (IllegalArgumentException e) {
                TranslatableComponent unknownOption = new TranslatableComponent("argument.entity.options.unknown", new Object[0]);
                unknownOption.setColor(ChatColor.RED);
                unknownOption.addWith(selector);
                sender.spigot().sendMessage((BaseComponent)unknownOption);
                return Collections.emptyList();
            }
        }
        return sender instanceof Entity ? Collections.singletonList((Entity)sender) : Collections.emptyList();
    }

    public static boolean parseBoolean(String bool, Messages errorMessage) throws ArgumentParseException {
        if (!bool.equalsIgnoreCase("true") && !bool.equalsIgnoreCase("false")) {
            throw new ArgumentParseException(errorMessage.getMessage());
        }
        return Boolean.parseBoolean(bool);
    }

    public static MaterialWithData parseBlock(String block) throws ArgumentParseException {
        return ArgumentParser.parseBlock(block, s -> {});
    }

    public static MaterialWithData parseBlock(String block, Consumer<String> itemConsumer) throws ArgumentParseException {
        int sep = Version.VersionType.V1_13.isHigherOrEqual() ? -1 : block.indexOf(":");
        Material m = Material.matchMaterial((String)block.substring(0, sep < 0 ? block.length() : sep));
        if (m == null || !m.isBlock()) {
            itemConsumer.accept(block);
            throw new ArgumentParseException(Messages.CMD_ERROR_UNKNOWN_BLOCK.getMessage().replace("%block%", block));
        }
        byte data = -1;
        if (sep > 0) {
            data = (byte)ArgumentParser.parsePositiveInt(block.substring(sep + 1), true, Messages.CMD_ERROR_NAN);
        }
        return new MaterialWithData(m, data);
    }

    public static MaterialWithData parseBlock(int index, List<String> args, Player player, boolean denyAir, boolean itemStackData, BiConsumer<Player, String> itemConsumer) throws ArgumentParseException {
        if (index < args.size()) {
            return ArgumentParser.parseBlock(args.get(index));
        }
        ItemStack item = player.getItemInHand();
        Material m = item.getType();
        if (!m.isBlock() || denyAir && ArgumentParser.isAir(m)) {
            itemConsumer.accept(player, m.name());
            throw new ArgumentParseException(Messages.CMD_ERROR_UNKNOWN_BLOCK.getMessage().replace("%block%", m.name()));
        }
        byte data = -1;
        if (itemStackData && !Version.VersionType.V1_13.isHigherOrEqual()) {
            data = item.getData().getData();
        }
        return new MaterialWithData(player.getItemInHand().getType(), data);
    }

    public static MaterialWithData parseBlock(int index, List<String> args, Player player, boolean denyAir, boolean itemStackData) throws ArgumentParseException {
        return ArgumentParser.parseBlock(index, args, player, denyAir, itemStackData, (p, input) -> {});
    }

    public static MaterialWithData parseBlock(int index, List<String> args, Player player, boolean denyAir, BiConsumer<Player, String> itemConsumer) throws ArgumentParseException {
        return ArgumentParser.parseBlock(index, args, player, denyAir, false, itemConsumer);
    }

    public static MaterialWithData parseBlock(int index, List<String> args, Player player, boolean denyAir) throws ArgumentParseException {
        return ArgumentParser.parseBlock(index, args, player, denyAir, false);
    }

    public static boolean isAir(Material material) {
        if (Version.VersionType.V1_13.isHigherOrEqual()) {
            return material.isAir();
        }
        return material.equals((Object)Material.AIR);
    }

    public static int parseInt(String nb, Messages errorMessage) throws ArgumentParseException {
        return ArgumentParser.parseInt(nb, errorMessage, Messages::getMessage);
    }

    public static int parseInt(String nb, Messages errorMessage, Function<Messages, String> messageToString) throws ArgumentParseException {
        try {
            return Integer.parseInt(nb);
        }
        catch (NumberFormatException e) {
            throw new ArgumentParseException(messageToString.apply(errorMessage));
        }
    }

    public static int parsePositiveInt(String nb, boolean includeOrigin, Messages errorMessage) throws ArgumentParseException {
        return ArgumentParser.parsePositiveInt(nb, includeOrigin, errorMessage, Messages::getMessage);
    }

    public static int parsePositiveInt(String nb, boolean includeOrigin, Messages errorMessage, Function<Messages, String> messageToString) throws ArgumentParseException {
        int integer = ArgumentParser.parseInt(nb, errorMessage, messageToString);
        if (integer <= 0 && !includeOrigin || integer < 0) {
            throw new ArgumentParseException(messageToString.apply(errorMessage));
        }
        return integer;
    }

    public static int parsePercentage(String percentage, Messages errorMessage) throws ArgumentParseException {
        int integer = ArgumentParser.parseInt(percentage, errorMessage);
        if (integer > 100 || integer < 0) {
            throw new ArgumentParseException(errorMessage.getMessage());
        }
        return integer;
    }

    public static int parseScoreboardLine(ScoreboardDisplayService scoreboard, boolean checkRange, String line, Messages errorMessage) throws ArgumentParseException {
        int integer = scoreboard.reverseIndex(ArgumentParser.parseInt(line, errorMessage));
        if (checkRange && integer < 0 || integer >= scoreboard.size()) {
            throw new ArgumentParseException(errorMessage.getMessage());
        }
        return integer;
    }

    public static int parseViewTime(String time, Messages errorMessage) throws ArgumentParseException {
        int integer = ArgumentParser.parseInt(time, errorMessage);
        if (integer > 30 || integer < 1) {
            throw new ArgumentParseException(errorMessage.getMessage());
        }
        return integer;
    }

    public static int parseOffset(String time, Messages errorMessage) throws ArgumentParseException {
        int integer = ArgumentParser.parseInt(time, errorMessage);
        if (integer > 10 || integer < 1) {
            throw new ArgumentParseException(errorMessage.getMessage());
        }
        return integer;
    }

    public static LockedChest getLockedChest(String name) throws ArgumentParseException {
        for (LockedChest chest : FkPI.getInstance().getLockedChestsManager().getChests()) {
            if (!chest.getName().equals(name)) continue;
            return chest;
        }
        throw new ArgumentParseException(Messages.CMD_ERROR_NOT_LOCKED_CHEST.getMessage());
    }

    public static class MaterialWithData {
        private final Material material;
        private final byte data;

        public MaterialWithData(Material material, byte data) {
            this.material = material;
            this.data = data;
        }

        public Material getMaterial() {
            return this.material;
        }

        public byte getData() {
            return this.data;
        }

        public String toString() {
            if (this.data < 0) {
                return this.material.name();
            }
            return this.material.name() + ':' + this.data;
        }
    }
}

