/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.FkCommandExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class FkAsyncCommandExecutor
extends FkCommandExecutor
implements Listener {
    private final Pattern delimiter = Pattern.compile(" ");

    public FkAsyncCommandExecutor(Fk plugin, PluginCommand command) {
        super(plugin, command);
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        plugin.getLogger().info("Enable asynchronous tab completion...");
    }

    @EventHandler(ignoreCancelled=true)
    public void onAsyncTabComplete(AsyncTabCompleteEvent e) {
        String[] stringArray;
        String label;
        if (!e.isCommand()) {
            return;
        }
        if (e.getBuffer().isEmpty()) {
            return;
        }
        String[] args = this.delimiter.split(e.getBuffer(), -1);
        String string = label = e.getBuffer().charAt(0) == '/' ? args[0].substring(1) : args[0];
        if (args.length > 1) {
            stringArray = Arrays.copyOfRange(args, 1, args.length);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        args = stringArray;
        if (!label.equals("fk")) {
            return;
        }
        e.setCompletions(this.tabCompleteCommand(this.plugin, e.getSender(), new ArrayList<String>(Arrays.asList(args))));
        e.setHandled(true);
    }
}

