/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.FkAsyncCommandExecutor;
import fr.devsylone.fallenkingdom.commands.brigadier.BrigadierManager;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;

public class FkLifecycleRegisteredExecutor
extends FkAsyncCommandExecutor {
    private final BrigadierManager<CommandSourceStack> builder = new BrigadierManager<CommandSourceStack>(CommandSourceStack::getSender);
    private SuggestionProvider<CommandSourceStack> suggestionProvider;

    public FkLifecycleRegisteredExecutor(Fk plugin, PluginCommand command) {
        super(plugin, command);
        LifecycleEventManager manager = plugin.getLifecycleManager();
        manager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            Commands commands = (Commands)event.registrar();
            CommandNode old = commands.getDispatcher().getRoot().getChild(command.getName());
            if (old != null) {
                old = (CommandNode)old.getChildren().iterator().next();
            }
            if (old instanceof ArgumentCommandNode) {
                this.suggestionProvider = ((ArgumentCommandNode)old).getCustomSuggestions();
            }
            LiteralCommandNode<CommandSourceStack> literal = this.builder.register(this, command.getName(), new RawExecutor((Command)command), this.suggestionProvider);
            commands.register(literal, (Collection)command.getAliases());
        });
    }

    private static class RawExecutor
    implements com.mojang.brigadier.Command<CommandSourceStack> {
        private final Command inner;

        private RawExecutor(Command inner) {
            this.inner = inner;
        }

        public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            String content = context.getRange().get(context.getInput());
            String[] args = StringUtils.split((String)content, (char)' ');
            if (context.getRange().getLength() == context.getInput().length()) {
                args = Arrays.copyOfRange(args, 1, args.length);
            }
            return this.inner.execute(sender, this.inner.getName(), args) ? 1 : 0;
        }
    }
}

