/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.abstraction;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandResult;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandRole;
import fr.devsylone.fallenkingdom.commands.abstraction.FkParentCommand;
import fr.devsylone.fallenkingdom.exception.FkLightException;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.version.FkSound;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCommand {
    protected final String name;
    protected final Messages description;
    protected final CommandRole role;
    protected String permission;
    @Nullable
    protected FkParentCommand parent;

    AbstractCommand(String name, Messages description, CommandRole role) {
        this.name = name;
        this.description = description;
        this.role = role;
        this.permission = "fallenkingdom.commands." + name;
    }

    public abstract CommandResult execute(Fk var1, CommandSender var2, List<String> var3, String var4) throws FkLightException, IllegalArgumentException;

    public abstract List<String> tabComplete(Fk var1, CommandSender var2, List<String> var3);

    public String getName() {
        return this.name;
    }

    public String getUsage() {
        return this.getName();
    }

    public String getFullUsage() {
        if (this.parent != null) {
            return this.parent.getFullUsage() + " " + this.getUsage();
        }
        return this.getUsage();
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        return this.description.getMessage();
    }

    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission(this.permission);
    }

    public boolean isValidExecutor(CommandSender sender) {
        return true;
    }

    public abstract int getMinArgumentCount();

    public abstract AbstractCommand get(List<String> var1);

    public abstract AbstractCommand get(Class<? extends AbstractCommand> var1);

    @Nullable
    public FkParentCommand getParent() {
        return this.parent;
    }

    @NotNull
    public CommandRole getRole() {
        return this.role;
    }

    @NotNull
    public String getPermission() {
        return this.permission;
    }

    @NotNull
    public Map<String, CommandRole> getPermissions() {
        return Collections.singletonMap(this.permission, this.role);
    }

    public void setParent(FkParentCommand parent) {
        this.parent = parent;
        this.permission = parent.permission + '.' + this.name;
    }

    protected void broadcast(String message) {
        if (this.getParent() == null) {
            Fk.broadcast(message);
            return;
        }
        this.getParent().broadcast(message);
        Bukkit.getConsoleSender().sendMessage(Messages.PREFIX_FK.getMessage() + message);
    }

    protected void broadcast(String message, int noBroadcastPos, List<String> args) {
        if (args.size() > noBroadcastPos && args.get(noBroadcastPos).equalsIgnoreCase("nobroadcast")) {
            return;
        }
        this.broadcast(message);
    }

    protected void broadcast(String message, FkSound sound) {
        this.broadcast(message);
        for (Player player : Fk.getInstance().getPlayerManager().getOnlinePlayers()) {
            player.playSound(player.getLocation(), sound.key(), 1.0f, 1.0f);
        }
    }

    protected void broadcastState(boolean state, Messages base, Messages trueMsg, Messages falseMsg) {
        Messages value = state ? trueMsg : falseMsg;
        this.broadcast(base.getMessage().replace("%state%", value.getMessage()));
    }

    public boolean shouldDisplay() {
        return true;
    }
}

