/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.abstraction;

import com.google.common.collect.ImmutableList;
import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.abstraction.IntegerArgument;
import fr.devsylone.fallenkingdom.utils.XAdvancement;
import fr.devsylone.fkpi.lockedchests.LockedChest;
import fr.devsylone.fkpi.teams.Team;
import fr.devsylone.fkpi.util.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class Argument<T> {
    private final String name;
    private final boolean required;
    private final String description;
    private final Class<T> typeClazz;

    public static Argument<String> create(String name, boolean required) {
        return Argument.create(name, required, "");
    }

    public static Argument<String> create(String name, boolean required, String description) {
        return new Argument<String>(name, required, description, String.class);
    }

    public static ImmutableList<Argument<?>> create(String usage) {
        String[] args = usage.split("([>\\]]) ?");
        ArrayList<Argument<String>> created = new ArrayList<Argument<String>>();
        for (String arg : args) {
            String name = arg.substring(1);
            String type = "s";
            Class clazz = String.class;
            if (name.contains(":")) {
                type = name.substring(0, name.indexOf(":"));
                clazz = Argument.getClassByToken(type);
                name = name.substring(name.indexOf(":") + 1);
            }
            boolean required = arg.startsWith("<");
            if (clazz.equals(Integer.TYPE)) {
                int sep = type.indexOf(";") > 0 ? type.indexOf(";") : type.length();
                int min = type.length() > 1 ? Integer.parseInt(type.substring(1, sep)) : 0;
                int max = type.length() > 1 && type.indexOf(";") > 0 ? Integer.parseInt(type.substring(sep + 1)) : Integer.MAX_VALUE;
                created.add(new IntegerArgument(name, required, "", min, max));
                continue;
            }
            created.add(new Argument<String>(name, required, "", clazz));
        }
        return ImmutableList.copyOf(created);
    }

    public static ImmutableList<Argument<?>> list(Argument<?> ... args) {
        return ImmutableList.copyOf((Object[])args);
    }

    public Argument(String name, boolean required, String description, Class<T> typeClazz) {
        this.name = name;
        this.required = required;
        this.description = description;
        this.typeClazz = typeClazz;
    }

    public String getName() {
        return this.name;
    }

    public String getForUsage() {
        if (this.isRequired()) {
            return "<" + this.name + ">";
        }
        return "[" + this.name + "]";
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDescription() {
        return this.description;
    }

    private static Class<?> getClassByToken(String token) {
        switch (token.charAt(0)) {
            case 'b': {
                return Boolean.TYPE;
            }
            case 'i': {
                return Integer.TYPE;
            }
        }
        return String.class;
    }

    public boolean shouldBrigadierAskServer() {
        return this.typeClazz == String.class && !this.name.equals("name") && !this.name.equals("block") && !this.name.equals("player") && !this.name.equals("entity");
    }

    public List<String> provideTabComplete(Fk plugin, String typed) {
        switch (this.name) {
            case "team": {
                return plugin.getFkPI().getTeamManager().getTeams().stream().map(Team::getName).filter(s -> this.startsWith((String)s, typed)).collect(Collectors.toList());
            }
            case "player": {
                return plugin.getServer().getOnlinePlayers().stream().map(Player::getName).filter(s -> this.startsWith((String)s, typed)).collect(Collectors.toList());
            }
            case "block": {
                return Arrays.stream(Material.values()).filter(Material::isBlock).filter(team -> this.startsWith(team.name(), typed)).map(m -> m.name().toLowerCase()).collect(Collectors.toList());
            }
            case "color": 
            case "newteam": {
                return Arrays.stream(Color.values()).filter(color -> this.startsWith(color.getGenredName(1), typed)).filter(color -> !color.getGenredName(1).contains(" ")).map(color -> color.getGenredName(1)).collect(Collectors.toList());
            }
            case "advancement": {
                ArrayList<String> suggestions = new ArrayList<String>();
                Iterator<String> iterator = XAdvancement.iterator();
                String key = typed;
                if (XAdvancement.isAdvancement()) {
                    String string = key = typed.contains(":") ? typed : "minecraft:" + typed;
                }
                while (iterator.hasNext()) {
                    String advancement = iterator.next();
                    if (!this.startsWith(advancement, key)) continue;
                    suggestions.add(advancement);
                }
                return suggestions;
            }
            case "chest": {
                return plugin.getFkPI().getLockedChestsManager().getChests().stream().map(LockedChest::getName).filter(s -> this.startsWith((String)s, typed)).collect(Collectors.toList());
            }
        }
        if (this.name.contains("|")) {
            return Arrays.stream(this.name.split("\\|")).filter(n -> this.startsWith((String)n, typed)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean startsWith(String word, String prefix) {
        return word.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public Class<T> getType() {
        return this.typeClazz;
    }
}

