/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.abstraction;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.utils.Messages;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public interface Confirmable {
    public static final int confirmationDelay = 10;
    public static final Map<UUID, Long> confirmed = new HashMap<UUID, Long>();

    default public boolean isConfirmed(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Long confirmation = confirmed.get(((Player)sender).getUniqueId());
        if (confirmation == null) {
            return false;
        }
        return confirmation > System.currentTimeMillis() - 10000L;
    }

    default public void addConfirmed(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return;
        }
        UUID uuid = ((Player)sender).getUniqueId();
        confirmed.put(uuid, System.currentTimeMillis());
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Fk.getInstance(), () -> confirmed.remove(uuid), 200L);
    }

    default public String createWarning(Messages warning, boolean format) {
        StringBuilder builder = new StringBuilder();
        if (format) {
            builder.append("\u00a7c\u00a7m--------------\u00a7c ").append(Messages.WARNING.getMessage()).append(" \u00a7c\u00a7m--------------\n");
        }
        builder.append(ChatColor.RESET).append(ChatColor.RED).append(warning.getMessage());
        if (format) {
            builder.append("\u00a7c\u00a7m--------------------------------------");
        }
        return builder.toString();
    }
}

