/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.abstraction;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.abstraction.AbstractCommand;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandResult;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandRole;
import fr.devsylone.fallenkingdom.exception.FkLightException;
import fr.devsylone.fallenkingdom.utils.Messages;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public abstract class FkParentCommand
extends AbstractCommand {
    private final List<? extends AbstractCommand> children;

    public FkParentCommand(String name, List<? extends AbstractCommand> children, Messages description, CommandRole permission) {
        super(name, description, permission);
        this.children = children;
        children.forEach(c -> c.setParent(this));
    }

    public FkParentCommand(String name, List<? extends AbstractCommand> children, Messages description) {
        this(name, children, description, CommandRole.PLAYER);
    }

    @Override
    public CommandResult execute(Fk plugin, CommandSender sender, List<String> args, String label) {
        if (!args.isEmpty() && !args.get(0).equalsIgnoreCase("help")) {
            throw new FkLightException(Messages.CMD_ERROR_UNKNOWN.getMessage().replace("%help%", '/' + label + ' ' + this.getFullUsage()));
        }
        this.children.stream().filter(s -> !plugin.getCommandManager().withPermissions() || s.hasPermission(sender)).forEach(s -> sender.sendMessage(ChatColor.GREEN + "/" + label + " " + s.getFullUsage() + " " + ChatColor.GRAY + s.getDescription()));
        return CommandResult.SUCCESS;
    }

    @Override
    public List<String> tabComplete(Fk plugin, CommandSender sender, List<String> args) {
        if (args.size() < 1) {
            return Collections.emptyList();
        }
        List<String> complete = this.children.stream().filter(s -> s.getName().toLowerCase().startsWith(((String)args.get(0)).toLowerCase())).filter(s -> plugin.getCommandManager().hasPermission(sender, s.permission)).map(AbstractCommand::getName).collect(Collectors.toList());
        if ("help".startsWith(args.get(0).toLowerCase())) {
            complete.add("help");
        }
        return complete;
    }

    @Override
    public int getMinArgumentCount() {
        return 0;
    }

    @Override
    public AbstractCommand get(List<String> args) {
        if (args.isEmpty()) {
            return this;
        }
        List sub = this.children.stream().filter(AbstractCommand::shouldDisplay).filter(s -> s.getName().equalsIgnoreCase((String)args.get(0))).collect(Collectors.toList());
        if (sub.size() == 1) {
            args.remove(0);
            return ((AbstractCommand)sub.get(0)).get(args);
        }
        return this;
    }

    @Override
    public AbstractCommand get(Class<? extends AbstractCommand> cmd) {
        if (this.getClass().equals(cmd)) {
            return this;
        }
        for (AbstractCommand abstractCommand : this.children) {
            AbstractCommand c = abstractCommand.get(cmd);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public List<? extends AbstractCommand> getChildren() {
        return this.children;
    }
}

