/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.brigadier;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import fr.devsylone.fallenkingdom.commands.abstraction.Argument;
import fr.devsylone.fallenkingdom.commands.abstraction.IntegerArgument;
import fr.devsylone.fallenkingdom.commands.brigadier.CommandBuildContextSupplier;
import fr.devsylone.fallenkingdom.commands.brigadier.MinecraftArgumentTypes;
import fr.devsylone.fallenkingdom.version.Version;
import org.bukkit.NamespacedKey;

class ArgumentTypeBuilder {
    ArgumentTypeBuilder() {
    }

    static <S> RequiredArgumentBuilder<S, ?> getFromArg(Argument<?> arg) {
        ArgumentType<?> argumentType;
        switch (arg.getName()) {
            case "block": {
                if (Version.VersionType.V1_19.isHigherOrEqual()) {
                    argumentType = MinecraftArgumentTypes.constructMinecraftArgumentType(NamespacedKey.minecraft((String)"block_state"), new Class[]{CommandBuildContextSupplier.COMMAND_BUILD_CONTEXT}, CommandBuildContextSupplier.create());
                    break;
                }
                argumentType = MinecraftArgumentTypes.getByKey(NamespacedKey.minecraft((String)"block_state"));
                break;
            }
            case "text": {
                argumentType = StringArgumentType.greedyString();
                break;
            }
            case "advancement": {
                argumentType = MinecraftArgumentTypes.getByKey(NamespacedKey.minecraft((String)"resource_location"));
                break;
            }
            case "entity": 
            case "player": {
                argumentType = MinecraftArgumentTypes.constructMinecraftArgumentType(NamespacedKey.minecraft((String)"entity"), new Class[]{Boolean.TYPE, Boolean.TYPE}, false, "player".equals(arg.getName()));
                break;
            }
            default: {
                argumentType = ArgumentTypeBuilder.getArgumentType(arg);
            }
        }
        return RequiredArgumentBuilder.argument((String)arg.getName(), argumentType);
    }

    private static ArgumentType<?> getArgumentType(Argument<?> arg) {
        switch (arg.getType().getSimpleName()) {
            case "int": {
                if (!(arg instanceof IntegerArgument)) {
                    throw new RuntimeException(arg.getName() + " doit contenir un entier mais n'impl\u00e9mente pas l'IntegerArgument.");
                }
                IntegerArgument intArg = (IntegerArgument)arg;
                return IntegerArgumentType.integer((int)intArg.getMinimum(), (int)intArg.getMaximum());
            }
            case "double": {
                return DoubleArgumentType.doubleArg();
            }
            case "boolean": {
                return BoolArgumentType.bool();
            }
        }
        return StringArgumentType.string();
    }
}

