/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.brigadier;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import fr.devsylone.fallenkingdom.commands.abstraction.AbstractCommand;
import fr.devsylone.fallenkingdom.commands.abstraction.Argument;
import fr.devsylone.fallenkingdom.commands.abstraction.FkCommand;
import fr.devsylone.fallenkingdom.commands.abstraction.FkParentCommand;
import fr.devsylone.fallenkingdom.commands.brigadier.ArgumentTypeBuilder;
import fr.devsylone.fallenkingdom.manager.CommandManager;
import java.util.List;
import java.util.function.Function;
import org.bukkit.command.CommandSender;

public class BrigadierManager<S> {
    private final Function<S, CommandSender> bukkitSender;

    public BrigadierManager(Function<S, CommandSender> bukkitSender) {
        this.bukkitSender = bukkitSender;
    }

    public LiteralCommandNode<S> register(CommandManager commandManager, LiteralCommandNode<S> root, SuggestionProvider<S> suggestionProvider) {
        return this.register(commandManager, root.getLiteral(), root.getCommand(), suggestionProvider);
    }

    public LiteralCommandNode<S> register(CommandManager commandManager, String literal, Command<S> executor, SuggestionProvider<S> suggestionProvider) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)literal).executes(executor);
        builder.then(LiteralArgumentBuilder.literal((String)"help").executes(executor));
        for (AbstractCommand abstractCommand : commandManager.getMainCommands()) {
            if (!abstractCommand.shouldDisplay()) continue;
            builder.then(this.buildCommandNode(abstractCommand, executor, suggestionProvider, commandManager.withPermissions()));
        }
        return builder.build();
    }

    CommandNode<S> buildCommandNode(AbstractCommand command, Command<S> executor, SuggestionProvider<S> suggestionProvider, boolean withPermissions) {
        LiteralCommandNode node;
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)command.getName()).requires(sender -> !withPermissions || command.hasPermission(this.bukkitSender.apply(sender)));
        if (command instanceof FkParentCommand) {
            builder.executes(executor);
            builder.then(LiteralArgumentBuilder.literal((String)"help").executes(executor));
            for (AbstractCommand abstractCommand : ((FkParentCommand)command).getChildren()) {
                if (!abstractCommand.shouldDisplay()) continue;
                builder.then(this.buildCommandNode(abstractCommand, executor, suggestionProvider, withPermissions));
            }
            return builder.build();
        }
        FkCommand cmd = (FkCommand)command;
        List<Argument<?>> list = cmd.getArguments();
        if (list.isEmpty() || !list.get(0).isRequired()) {
            builder.executes(executor);
        }
        LiteralCommandNode prevNode = node = builder.build();
        for (int i = 0; i < list.size(); ++i) {
            RequiredArgumentBuilder arg = ArgumentTypeBuilder.getFromArg(list.get(i));
            if (list.get(i).shouldBrigadierAskServer()) {
                arg.suggests(suggestionProvider);
            }
            if (i == list.size() - 1 || !list.get(i + 1).isRequired()) {
                arg.executes(executor);
            }
            LiteralCommandNode literalCommandNode = prevNode;
            prevNode = arg.build();
            literalCommandNode.addChild((CommandNode)prevNode);
        }
        return node;
    }
}

