/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.brigadier;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import fr.devsylone.fallenkingdom.commands.brigadier.BrigadierManager;
import fr.devsylone.fallenkingdom.manager.CommandManager;
import fr.devsylone.fallenkingdom.utils.NMSUtils;
import fr.devsylone.fallenkingdom.utils.PacketUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;

public class BrigadierSpigotManager<S>
extends BrigadierManager<S>
implements Listener {
    private final CommandManager commandManager;
    private final PluginCommand pluginCommand;
    private final List<LiteralCommandNode<S>> registeredNodes = new ArrayList<LiteralCommandNode<S>>();
    private static final Field CONSOLE_FIELD;
    private static final Method GET_COMMAND_DISPATCHER_METHOD;
    private static final Method GET_BRIGADIER_DISPATCHER_METHOD;
    private static final Method GET_BUKKIT_SENDER_METHOD;
    private static final Constructor<?> COMMAND_WRAPPER_CONSTRUCTOR;
    private static final Field[] CHILDREN_FIELDS;

    public BrigadierSpigotManager(Plugin plugin, CommandManager commandManager, PluginCommand pluginCommand) {
        super(BrigadierSpigotManager::getBukkitSender);
        this.commandManager = commandManager;
        this.pluginCommand = pluginCommand;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    private void register(CommandDispatcher<S> dispatcher) {
        CommandNode root = Objects.requireNonNull(dispatcher.getRoot().getChild("fk"), "plugin root command");
        LiteralCommandNode<S> node = this.register(this.commandManager, this.pluginCommand.getLabel(), root.getCommand(), this.getSuggestionProvider(this.pluginCommand));
        this.registeredNodes.add(node);
    }

    private CommandDispatcher<S> getDispatcher() {
        try {
            Object mcServerObject = CONSOLE_FIELD.get(Bukkit.getServer());
            Object commandDispatcherObject = GET_COMMAND_DISPATCHER_METHOD.invoke(mcServerObject, new Object[0]);
            return (CommandDispatcher)GET_BRIGADIER_DISPATCHER_METHOD.invoke(commandDispatcherObject, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private SuggestionProvider<S> getSuggestionProvider(PluginCommand command) {
        try {
            return (SuggestionProvider)COMMAND_WRAPPER_CONSTRUCTOR.newInstance(Bukkit.getServer(), command);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private void removeChild(RootCommandNode<S> root, String name) {
        try {
            for (Field field : CHILDREN_FIELDS) {
                Map children = (Map)field.get(root);
                children.remove(name);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static CommandSender getBukkitSender(Object commandWrapperListener) {
        try {
            return (CommandSender)GET_BUKKIT_SENDER_METHOD.invoke(commandWrapperListener, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @EventHandler
    public void onLoad(ServerLoadEvent event) {
        CommandDispatcher<S> dispatcher = this.getDispatcher();
        if (this.registeredNodes.isEmpty()) {
            this.register(dispatcher);
        }
        for (LiteralCommandNode<S> node : this.registeredNodes) {
            this.removeChild(dispatcher.getRoot(), node.getName());
            dispatcher.getRoot().addChild(node);
        }
    }

    static {
        try {
            Class<?> craftServer = NMSUtils.obcClass("CraftServer");
            CONSOLE_FIELD = craftServer.getDeclaredField("console");
            CONSOLE_FIELD.setAccessible(true);
            Class<?> minecraftServer = PacketUtils.MINECRAFT_SERVER;
            Class<?> commandDispatcher = NMSUtils.nmsClass("commands", "CommandDispatcher");
            GET_COMMAND_DISPATCHER_METHOD = NMSUtils.getMethod(minecraftServer, commandDispatcher, new Class[0]);
            GET_COMMAND_DISPATCHER_METHOD.setAccessible(true);
            GET_BRIGADIER_DISPATCHER_METHOD = Arrays.stream(commandDispatcher.getDeclaredMethods()).filter(method -> method.getParameterCount() == 0).filter(method -> CommandDispatcher.class.isAssignableFrom(method.getReturnType())).findFirst().orElseThrow(NoSuchMethodException::new);
            GET_BRIGADIER_DISPATCHER_METHOD.setAccessible(true);
            Class<?> commandListenerWrapper = NMSUtils.nmsClass("commands", "CommandListenerWrapper");
            GET_BUKKIT_SENDER_METHOD = commandListenerWrapper.getDeclaredMethod("getBukkitSender", new Class[0]);
            GET_BUKKIT_SENDER_METHOD.setAccessible(true);
            Class<?> bukkitCommandWrapper = NMSUtils.obcClass("command.BukkitCommandWrapper");
            COMMAND_WRAPPER_CONSTRUCTOR = bukkitCommandWrapper.getConstructor(craftServer, Command.class);
            Field childrenField = CommandNode.class.getDeclaredField("children");
            Field literalsField = CommandNode.class.getDeclaredField("literals");
            Field argumentsField = CommandNode.class.getDeclaredField("arguments");
            for (Field field : CHILDREN_FIELDS = new Field[]{childrenField, literalsField, argumentsField}) {
                field.setAccessible(true);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

