/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.brigadier;

import fr.devsylone.fallenkingdom.utils.NMSUtils;
import fr.devsylone.fallenkingdom.utils.PacketUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CommandBuildContextSupplier {
    static final Class<?> COMMAND_BUILD_CONTEXT;
    @Nullable
    private static final Constructor<?> COMMAND_BUILD_CONTEXT_CONSTRUCTOR;
    @Nullable
    private static final Method CREATE_CONTEXT_METHOD;
    @Nullable
    private static final Method GET_WORLD_DATA_METHOD;
    @Nullable
    private static final Method GET_FEATURE_FLAGS_METHOD;
    private static final Method REGISTRY_ACCESS;

    CommandBuildContextSupplier() {
    }

    @NotNull
    static Object create() {
        try {
            Object registryAccess = REGISTRY_ACCESS.invoke(PacketUtils.getNMSServer(), new Object[0]);
            if (COMMAND_BUILD_CONTEXT_CONSTRUCTOR != null) {
                return COMMAND_BUILD_CONTEXT_CONSTRUCTOR.newInstance(registryAccess);
            }
            Object worldData = GET_WORLD_DATA_METHOD.invoke(PacketUtils.getNMSServer(), new Object[0]);
            Object flags = GET_FEATURE_FLAGS_METHOD.invoke(worldData, new Object[0]);
            return CREATE_CONTEXT_METHOD.invoke(null, registryAccess, flags);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            COMMAND_BUILD_CONTEXT = NMSUtils.nmsClass("commands", "CommandBuildContext");
            Constructor<?>[] constructors = COMMAND_BUILD_CONTEXT.getDeclaredConstructors();
            if (constructors.length == 0) {
                COMMAND_BUILD_CONTEXT_CONSTRUCTOR = null;
                CREATE_CONTEXT_METHOD = Arrays.stream(COMMAND_BUILD_CONTEXT.getDeclaredMethods()).filter(it -> it.getParameterCount() == 2 && COMMAND_BUILD_CONTEXT.isAssignableFrom(it.getReturnType()) && Modifier.isStatic(it.getModifiers())).findFirst().orElseThrow(() -> new NoSuchMethodException("Could not find CommandBuildContext.configurable"));
                Class<?> worldDataCls = NMSUtils.nmsClass("world.level.storage", "SaveData", "WorldData");
                GET_WORLD_DATA_METHOD = Arrays.stream(PacketUtils.MINECRAFT_SERVER.getDeclaredMethods()).filter(method -> method.getParameterCount() == 0 && !Modifier.isStatic(method.getModifiers()) && method.getReturnType().equals(worldDataCls)).findFirst().orElseThrow(() -> new NoSuchMethodException("Could not find MinecraftServer#getWorldData method"));
                Class<?> featureFlagSetCls = NMSUtils.nmsClass("world.flag", "FeatureFlagSet");
                GET_FEATURE_FLAGS_METHOD = Arrays.stream(worldDataCls.getDeclaredMethods()).filter(method -> method.getParameterCount() == 0 && method.getReturnType().equals(featureFlagSetCls) && !Modifier.isStatic(method.getModifiers())).findFirst().orElseThrow(() -> new NoSuchMethodException("Could not find enabledFeatures method"));
            } else {
                COMMAND_BUILD_CONTEXT_CONSTRUCTOR = COMMAND_BUILD_CONTEXT.getDeclaredConstructors()[0];
                CREATE_CONTEXT_METHOD = null;
                GET_WORLD_DATA_METHOD = null;
                GET_FEATURE_FLAGS_METHOD = null;
            }
            Class<?> registryAccess = COMMAND_BUILD_CONTEXT_CONSTRUCTOR != null ? COMMAND_BUILD_CONTEXT_CONSTRUCTOR.getParameterTypes()[0] : CREATE_CONTEXT_METHOD.getParameterTypes()[0];
            REGISTRY_ACCESS = Arrays.stream(PacketUtils.MINECRAFT_SERVER.getDeclaredMethods()).filter(m -> registryAccess.isAssignableFrom(m.getReturnType())).findFirst().orElseThrow(() -> new NoSuchMethodException("Cannot find MinecraftServer#registryAccess"));
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

