/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.brigadier;

import com.mojang.brigadier.arguments.ArgumentType;
import fr.devsylone.fallenkingdom.utils.NMSUtils;
import fr.devsylone.fallenkingdom.version.Version;
import fr.devsylone.fallenkingdom.version.tracker.InternalRegistry;
import fr.devsylone.fallenkingdom.version.tracker.MinecraftKey;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MinecraftArgumentTypes {
    private static final ArgumentTypeRegistry ARGUMENT_TYPE_REGISTRY;
    private static final Field BY_CLASS_MAP_FIELD;

    private MinecraftArgumentTypes() {
    }

    public static Class<? extends ArgumentType<?>> getClassByKey(NamespacedKey key) throws IllegalArgumentException {
        try {
            Object entry = ARGUMENT_TYPE_REGISTRY.find(key);
            if (entry == null) {
                throw new IllegalArgumentException(key.toString());
            }
            Map map = (Map)BY_CLASS_MAP_FIELD.get(null);
            for (Map.Entry mapEntry : map.entrySet()) {
                if (mapEntry.getValue() != entry) continue;
                return (Class)mapEntry.getKey();
            }
            throw new IllegalArgumentException(key.toString());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static ArgumentType<?> getByKey(NamespacedKey key) throws IllegalArgumentException {
        try {
            Constructor<ArgumentType<?>> constructor = MinecraftArgumentTypes.getClassByKey(key).getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static ArgumentType<?> constructMinecraftArgumentType(NamespacedKey key, Class<?>[] argTypes, Object ... args) {
        try {
            Constructor<ArgumentType<?>> constructor = MinecraftArgumentTypes.getClassByKey(key).getDeclaredConstructor(argTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Class<?> argumentRegistry;
            if (Version.VersionType.V1_19.isHigherOrEqual()) {
                argumentRegistry = NMSUtils.nmsClass("commands.synchronization", "ArgumentTypeInfos");
                ARGUMENT_TYPE_REGISTRY = new ArgumentTypeRegistry1_19();
            } else {
                argumentRegistry = NMSUtils.nmsClass("commands.synchronization", "ArgumentRegistry");
                ARGUMENT_TYPE_REGISTRY = new ArgumentTypeRegistry1_13(argumentRegistry);
            }
            BY_CLASS_MAP_FIELD = Arrays.stream(argumentRegistry.getDeclaredFields()).filter(field -> field.getType().equals(Map.class)).filter(field -> {
                ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
                Type param = parameterizedType.getActualTypeArguments()[0];
                if (!(param instanceof ParameterizedType)) {
                    return false;
                }
                return ((ParameterizedType)param).getRawType().equals(Class.class);
            }).findFirst().orElseThrow(NoSuchFieldException::new);
            BY_CLASS_MAP_FIELD.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static interface ArgumentTypeRegistry {
        @Nullable
        public Object find(@NotNull NamespacedKey var1) throws ReflectiveOperationException;
    }

    private static class ArgumentTypeRegistry1_19
    implements ArgumentTypeRegistry {
        private final InternalRegistry<Object> registry = new InternalRegistry(NamespacedKey.minecraft((String)"command_argument_type"));

        private ArgumentTypeRegistry1_19() throws InvocationTargetException, IllegalAccessException {
        }

        @Override
        @Nullable
        public Object find(@NotNull NamespacedKey identifier) throws ReflectiveOperationException {
            return this.registry.get(identifier);
        }
    }

    private static class ArgumentTypeRegistry1_13
    implements ArgumentTypeRegistry {
        private final Method argumentRegistryGetByKey;

        private ArgumentTypeRegistry1_13(@NotNull Class<?> argumentRegistry) throws ReflectiveOperationException {
            this.argumentRegistryGetByKey = Arrays.stream(argumentRegistry.getDeclaredMethods()).filter(method -> method.getParameterCount() == 1).filter(method -> MinecraftKey.IDENTIFIER.equals(method.getParameterTypes()[0])).findFirst().orElseThrow(NoSuchMethodException::new);
            this.argumentRegistryGetByKey.setAccessible(true);
        }

        @Override
        @Nullable
        public Object find(@NotNull NamespacedKey identifier) throws ReflectiveOperationException {
            return this.argumentRegistryGetByKey.invoke(null, MinecraftKey.identifier(identifier));
        }
    }
}

