/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.chests.chestscommands;

import com.google.common.collect.Sets;
import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.ArgumentParser;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandResult;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandRole;
import fr.devsylone.fallenkingdom.commands.abstraction.FkPlayerCommand;
import fr.devsylone.fallenkingdom.players.FkPlayer;
import fr.devsylone.fallenkingdom.utils.ChatUtils;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.utils.XAdvancement;
import fr.devsylone.fallenkingdom.utils.XMaterial;
import fr.devsylone.fallenkingdom.version.Version;
import fr.devsylone.fallenkingdom.version.advancement.BukkitAdvancement;
import fr.devsylone.fallenkingdom.version.advancement.PaperAdvancement;
import fr.devsylone.fkpi.FkPI;
import fr.devsylone.fkpi.lockedchests.LockedChest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ChestLock
extends FkPlayerCommand
implements Listener {
    private final String INVENTORY_NAME = ChatColor.YELLOW + "Advancements";
    private final List<ItemStack> categories = new ArrayList<ItemStack>();
    private final Map<String, List<ItemStack>> representations = new HashMap<String, List<ItemStack>>();
    private final Set<Inventory> inventories = new HashSet<Inventory>();

    public ChestLock() {
        super("lock", "[advancement] [chest]", Messages.CMD_MAP_CHEST_LOCK, CommandRole.ADMIN);
        if (Bukkit.getServer() != null) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Fk.getInstance());
        }
    }

    @Override
    public CommandResult execute(Fk plugin, Player sender, FkPlayer fkp, List<String> args, String label) {
        if (args.size() < 1) {
            plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                if (this.representations.size() < 1) {
                    if (XAdvancement.isAdvancement()) {
                        this.buildAdvancementsRepresentation();
                    } else {
                        this.buildAchievementRepresentation();
                    }
                }
                Inventory inventory = Bukkit.createInventory((InventoryHolder)sender, (int)27, (String)this.INVENTORY_NAME);
                inventory.addItem(this.categories.toArray(new ItemStack[0]));
                this.inventories.add(inventory);
                if (sender != null && sender.isOnline()) {
                    plugin.getServer().getScheduler().runTask((Plugin)plugin, () -> sender.openInventory(inventory));
                }
            });
            return CommandResult.SUCCESS;
        }
        String advancement = args.get(0);
        if (XAdvancement.exist(advancement)) {
            if (args.size() < 2) {
                return this.setLock((LivingEntity)sender, advancement);
            }
            return this.setLock(ArgumentParser.getLockedChest(args.get(1)), advancement);
        }
        TranslatableComponent component = new TranslatableComponent(XAdvancement.isAdvancement() ? "advancement.advancementNotFound" : "commands.achievement.unknownAchievement", new Object[0]);
        component.addWith(advancement);
        component.setColor(ChatColor.RED);
        sender.spigot().sendMessage((BaseComponent)component);
        return CommandResult.INVALID_ARGS;
    }

    private void buildAchievementRepresentation() {
        ItemStack itemStack = new ItemStack(XMaterial.GRASS_BLOCK.parseMaterial());
        ItemMeta meta = itemStack.getItemMeta();
        meta.setDisplayName(ChatColor.RESET.toString() + ChatColor.YELLOW + "Minecraft");
        meta.setLore(Collections.singletonList(ChatColor.RESET.toString() + ChatColor.GRAY + "Achievements"));
        itemStack.setItemMeta(meta);
        this.categories.add(itemStack);
        this.representations.put("Achievements", new ArrayList());
        for (Object achievement : XAdvancement.getAchievements()) {
            this.representations.get("Achievements").add(XAdvancement.getAchievementIcon(achievement));
        }
    }

    private void buildAdvancementsRepresentation() {
        if (Version.classExists("io.papermc.paper.advancement.AdvancementDisplay")) {
            PaperAdvancement.buildAdvancements(this.categories, this.representations);
        } else {
            BukkitAdvancement.buildAdvancements(this.categories, this.representations);
        }
    }

    @EventHandler
    public void onInvClick(InventoryClickEvent event) {
        if (event.getClickedInventory() instanceof PlayerInventory || !this.inventories.contains(event.getInventory()) || event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null) {
            return;
        }
        event.setCancelled(true);
        List lore = event.getCurrentItem().getItemMeta().getLore();
        if (lore == null || lore.size() < 1) {
            return;
        }
        String root = ChatColor.stripColor((String)((String)lore.get(0)));
        List<ItemStack> representations = root.equals("Achievements") ? this.representations.values().iterator().next() : this.representations.get(root);
        if (representations == null) {
            this.setLock((LivingEntity)event.getWhoClicked(), root);
            return;
        }
        this.inventories.remove(event.getInventory());
        Inventory inventory = Bukkit.createInventory((InventoryHolder)event.getWhoClicked(), (int)((representations.size() + 8) / 9 * 9), (String)this.INVENTORY_NAME);
        for (ItemStack itemStack : representations) {
            inventory.addItem(new ItemStack[]{itemStack});
        }
        this.inventories.add(inventory);
        event.getWhoClicked().openInventory(inventory);
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        this.inventories.remove(event.getInventory());
    }

    private CommandResult setLock(LivingEntity livingEntity, String advancement) {
        Block target = livingEntity.getTargetBlock((Set)Sets.newHashSet((Object[])new Material[]{Material.AIR}), 10);
        LockedChest chest = FkPI.getInstance().getLockedChestsManager().getChestAt(target.getLocation());
        if (chest == null) {
            ChatUtils.sendMessage((CommandSender)livingEntity, Messages.CMD_ERROR_NOT_LOCKED_CHEST);
            return CommandResult.INVALID_ARGS;
        }
        return this.setLock(chest, advancement);
    }

    private CommandResult setLock(LockedChest chest, String advancement) {
        chest.setRequiredAdvancement(advancement);
        this.broadcast(Messages.CMD_LOCKED_CHEST_LOCKED.getMessage().replace("%name%", chest.getName()).replace("%day%", String.valueOf(chest.getUnlockDay())).replace("%advancement%", advancement));
        return CommandResult.SUCCESS;
    }
}

