/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.chests.chestscommands;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandResult;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandRole;
import fr.devsylone.fallenkingdom.commands.abstraction.FkCommand;
import fr.devsylone.fallenkingdom.exception.FkLightException;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fkpi.lockedchests.LockedChest;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class ChestsList
extends FkCommand {
    public ChestsList() {
        super("list", Messages.CMD_MAP_CHEST_LIST, CommandRole.PLAYER);
    }

    @Override
    public CommandResult execute(Fk plugin, CommandSender sender, List<String> args, String label) {
        if (Fk.getInstance().getFkPI().getLockedChestsManager().getChestMap().isEmpty()) {
            throw new FkLightException(Messages.CMD_ERROR_EMPTY_CHESTS_LIST);
        }
        ArrayList<String> builder = new ArrayList<String>();
        builder.add(ChatColor.DARK_GREEN + "\u00a7m----------------- " + ChatColor.BLUE + (Object)((Object)Messages.CMD_TEAMS_AND_CHESTS_LIST) + ChatColor.DARK_GREEN + " \u00a7m-----------------");
        for (LockedChest chest : Fk.getInstance().getFkPI().getLockedChestsManager().getChests()) {
            builder.add(Messages.CMD_LOCKED_CHEST_LIST_INFO.getMessage().replace("%name%", chest.getName()).replace("%day%", String.valueOf(chest.getUnlockDay())).replace("%time%", String.valueOf(chest.getUnlockingTimeSecs())));
            builder.add(Messages.CMD_LOCKED_CHEST_LIST_POSITION.getMessage().replace("%x%", String.valueOf(chest.getLocation().getBlockX())).replace("%y%", String.valueOf(chest.getLocation().getBlockY())).replace("%z%", String.valueOf(chest.getLocation().getBlockZ())));
            builder.add(ChatColor.DARK_GREEN + "\u00a7m----------------------------------------");
        }
        sender.sendMessage(builder.toArray(new String[0]));
        return CommandResult.SUCCESS;
    }
}

