/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.game.gamescommands;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandResult;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandRole;
import fr.devsylone.fallenkingdom.commands.abstraction.FkCommand;
import fr.devsylone.fallenkingdom.exception.FkLightException;
import fr.devsylone.fallenkingdom.game.Game;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.version.FkSound;
import fr.devsylone.fkpi.rules.Rule;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class Resume
extends FkCommand {
    public Resume() {
        super("resume", Messages.CMD_MAP_GAME_RESUME, CommandRole.ADMIN);
    }

    @Override
    public CommandResult execute(Fk plugin, CommandSender sender, List<String> args, String label) {
        if (plugin.getGame().isPreStart()) {
            throw new FkLightException(Messages.CMD_ERROR_GAME_NOT_STARTED);
        }
        if (plugin.getGame().getState().equals((Object)Game.GameState.STARTED)) {
            throw new FkLightException(Messages.CMD_ERROR_NOT_IN_PAUSE);
        }
        plugin.getGame().startTimer();
        plugin.getGame().setState(Game.GameState.STARTED);
        if (!plugin.getFkPI().getRulesManager().getRule(Rule.ETERNAL_DAY).booleanValue()) {
            for (World w : Bukkit.getWorlds()) {
                if (!plugin.getWorldManager().isAffected(w)) continue;
                w.setGameRuleValue("doDaylightCycle", "true");
            }
        }
        plugin.getDeepPauseManager().unfreezePlayers();
        plugin.getDeepPauseManager().resetAIs();
        plugin.getDeepPauseManager().unprotectItems();
        this.broadcast(Messages.CMD_GAME_RESUME.getMessage(), FkSound.NOTE_HARP);
        return CommandResult.SUCCESS;
    }
}

