/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.lang;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandResult;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandRole;
import fr.devsylone.fallenkingdom.commands.abstraction.FkCommand;
import fr.devsylone.fallenkingdom.utils.ChatUtils;
import fr.devsylone.fallenkingdom.utils.Messages;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class TryLoad
extends FkCommand {
    public TryLoad() {
        super("tryload", Messages.CMD_MAP_LANG_TRY_LOAD, CommandRole.ADMIN);
    }

    @Override
    public CommandResult execute(Fk plugin, CommandSender sender, List<String> args, String label) {
        plugin.getLogger().info("Start of lang report");
        long missingTranslations = Arrays.stream(Messages.values()).filter(message -> {
            try {
                plugin.getLanguageManager().get((Messages)((Object)message));
            }
            catch (MissingResourceException ex) {
                Fk.getInstance().getLogger().severe("Value of " + message.getAccessor() + " not set in any file!");
                return true;
            }
            return false;
        }).count();
        plugin.getLogger().info("End of lang report");
        ChatUtils.sendMessage(sender, Messages.CMD_LANG_TRY_LOAD);
        if (missingTranslations > 0L) {
            ChatUtils.sendMessage(sender, ChatColor.RED + Messages.CMD_LANG_TRY_LOAD_MISSING.getMessage().replace("%nb%", String.valueOf(missingTranslations)));
        }
        return CommandResult.SUCCESS;
    }
}

