/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.rules;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.ArgumentParser;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandResult;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandRole;
import fr.devsylone.fallenkingdom.commands.abstraction.FkCommand;
import fr.devsylone.fallenkingdom.exception.FkLightException;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fkpi.FkPI;
import fr.devsylone.fkpi.rules.Rule;
import java.util.List;
import org.bukkit.command.CommandSender;

public abstract class FkBooleanRuleCommand
extends FkCommand {
    private final Rule<Boolean> booleanRule;

    public FkBooleanRuleCommand(String path, Messages description, Rule<Boolean> booleanRule) {
        super(path, "<b:true|false>", description, CommandRole.ADMIN);
        this.booleanRule = booleanRule;
    }

    @Override
    public final CommandResult execute(Fk plugin, CommandSender sender, List<String> args, String label) {
        boolean value = ArgumentParser.parseBoolean(args.get(0), Messages.CMD_ERROR_BOOL_FORMAT);
        if (value == FkPI.getInstance().getRulesManager().getRule(this.booleanRule)) {
            throw new FkLightException(Messages.CMD_ERROR_RULES_ALREADY_DEFINED);
        }
        FkPI.getInstance().getRulesManager().setRule(this.booleanRule, value);
        this.sendMessage(value);
        return CommandResult.SUCCESS;
    }

    protected abstract void sendMessage(boolean var1);

    protected void broadcastOnOff(boolean state, Messages msg) {
        this.broadcastState(state, msg, Messages.CMD_RULES_ACTIVATED, Messages.CMD_RULES_DEACTIVATED);
    }

    protected void broadcastPossibleImpossible(boolean state, Messages msg) {
        this.broadcastState(state, msg, Messages.CMD_RULES_POSSIBLE, Messages.CMD_RULES_IMPOSSIBLE);
    }
}

