/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.rules.rulescommands;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.ArgumentParser;
import fr.devsylone.fallenkingdom.commands.abstraction.Argument;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandResult;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandRole;
import fr.devsylone.fallenkingdom.commands.abstraction.FkCommand;
import fr.devsylone.fallenkingdom.exception.FkLightException;
import fr.devsylone.fallenkingdom.utils.ChatUtils;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.utils.XMaterial;
import fr.devsylone.fkpi.FkPI;
import fr.devsylone.fkpi.rules.AllowedBlocks;
import fr.devsylone.fkpi.rules.Rule;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AllowBlock
extends FkCommand {
    public AllowBlock() {
        super("allowBlock", (List<Argument<?>>)Argument.list(Argument.create("block", false, "sinon prendra le bloc tenu en main")), Messages.CMD_MAP_RULES_ALLOW_BLOCK, CommandRole.ADMIN);
    }

    @Override
    public CommandResult execute(Fk plugin, CommandSender sender, List<String> args, String label) {
        ArgumentParser.MaterialWithData material;
        if (!(sender instanceof Player)) {
            if (args.size() <= 0) {
                return CommandResult.NOT_VALID_EXECUTOR;
            }
            material = ArgumentParser.parseBlock(args.get(0), input -> AllowBlock.enderEyeSuggestion(sender, input));
        } else {
            material = ArgumentParser.parseBlock(0, args, (Player)sender, true, AllowBlock::enderEyeSuggestion);
        }
        AllowBlock.enderEyeSuggestion(sender, material.getMaterial().name());
        AllowedBlocks rule = FkPI.getInstance().getRulesManager().getRule(Rule.ALLOWED_BLOCKS);
        if (rule.isAllowed(material.getMaterial(), material.getData())) {
            throw new FkLightException(Messages.CMD_RULES_ERROR_ALREADY_ALLOWED);
        }
        rule.add(material.getMaterial(), material.getData());
        this.broadcast(Messages.CMD_RULES_ALLOW_BLOCK.getMessage().replace("%block%", material.toString()));
        return CommandResult.SUCCESS;
    }

    private static void enderEyeSuggestion(CommandSender sender, String input) {
        AllowBlock.makeSuggestionIf(input, "ender", (Object)((Object)Messages.CMD_RULES_ENDER_EYE_MSG) + " " + XMaterial.END_PORTAL_FRAME.parseMaterial().name() + "&a.", sender);
    }

    private static void makeSuggestionIf(String haystack, String needle, String message, CommandSender sender) {
        if (haystack.toLowerCase().contains(needle.toLowerCase())) {
            ChatUtils.sendMessage(sender, message);
        }
    }
}

