/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.rules.rulescommands;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandResult;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandRole;
import fr.devsylone.fallenkingdom.commands.abstraction.FkPlayerCommand;
import fr.devsylone.fallenkingdom.players.FkPlayer;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.utils.PluginInventory;
import fr.devsylone.fallenkingdom.utils.XItemStack;
import fr.devsylone.fallenkingdom.utils.XMaterial;
import fr.devsylone.fallenkingdom.version.Environment;
import fr.devsylone.fallenkingdom.version.potion.PotionIterator;
import fr.devsylone.fkpi.rules.Rule;
import fr.devsylone.fkpi.util.XPotionData;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemLore;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisabledPotions
extends FkPlayerCommand {
    @Nullable
    private Editor editor;

    public DisabledPotions() {
        super("disabledPotions", Messages.CMD_MAP_RULES_DISABLED_POTIONS, CommandRole.ADMIN);
    }

    @Override
    public CommandResult execute(Fk plugin, Player sender, FkPlayer fkp, List<String> args, String label) {
        if (this.editor == null) {
            this.editor = Environment.HAS_DATA_COMPONENTS ? new EditorPaper(plugin) : new Editor(plugin);
        }
        sender.openInventory(this.editor.getInventory());
        return CommandResult.SUCCESS;
    }

    private class Editor
    implements PluginInventory {
        protected final fr.devsylone.fkpi.rules.DisabledPotions rule;
        private final Inventory inventory;
        private final ItemStack disableAmplifiedPotionsItem;

        public Editor(Fk plugin) {
            this.rule = plugin.getFkPI().getRulesManager().getRule(Rule.DISABLED_POTIONS);
            this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, Messages.INVENTORY_POTION_TITLE.getMessage());
            this.disableAmplifiedPotionsItem = XMaterial.PLAYER_HEAD.parseItem();
            SkullMeta meta = XItemStack.applyBase64Texture((SkullMeta)this.disableAmplifiedPotionsItem.getItemMeta(), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTZmYWI5OTFkMDgzOTkzY2I4M2U0YmNmNDRhMGI2Y2VmYWM2NDdkNDE4OWVlOWNiODIzZTljYzE1NzFlMzgifX19");
            meta.setDisplayName(Messages.INVENTORY_POTION_LEVEL_II.getMessage());
            this.disableAmplifiedPotionsItem.setItemMeta((ItemMeta)meta);
            ItemStack glassPane = XMaterial.CYAN_STAINED_GLASS_PANE.parseItem();
            for (int i = 0; i < 9; ++i) {
                this.inventory.setItem(i, glassPane);
            }
            this.inventory.setItem(4, this.disableAmplifiedPotionsItem);
            Iterator<XPotionData> iterator = PotionIterator.create(PotionType.values());
            int slot = 8;
            while (iterator.hasNext()) {
                XPotionData potionData = iterator.next();
                if (potionData.getType().getEffectType() == null) continue;
                ItemStack potionItem = XMaterial.POTION.parseItem();
                this.inventory.setItem(++slot, this.updateItem(potionItem, potionData));
            }
        }

        @Override
        public void onInventoryClick(@NotNull InventoryClickEvent event) {
            if (event.getCurrentItem() == null) {
                return;
            }
            event.setCancelled(true);
            XPotionData potionData = XPotionData.fromItemStack(event.getCurrentItem());
            if (potionData != null) {
                event.setCurrentItem(this.click(potionData));
            } else if (event.getCurrentItem().getType() == this.disableAmplifiedPotionsItem.getType()) {
                ItemStack[] contents = this.inventory.getContents();
                for (int i = 0; i < contents.length; ++i) {
                    ItemStack item = contents[i];
                    if (item == null || (potionData = XPotionData.fromItemStack(item)) == null || !potionData.isUpgraded() || this.rule.isDisabled(potionData)) continue;
                    contents[i] = this.click(potionData);
                }
                this.inventory.setContents(contents);
            }
        }

        @NotNull
        private ItemStack click(@NotNull XPotionData data) {
            String potionName = data.getType().name();
            if (!PotionIterator.USE_SEPARATE_POTION_TYPES) {
                potionName = potionName + (data.isExtended() ? " + redstone" : (data.isUpgraded() ? " + glowstone" : ""));
            }
            if (this.rule.togglePotion(data)) {
                DisabledPotions.this.broadcast(Messages.INVENTORY_POTION_ENABLE_CLICK.getMessage().replace("%potion%", potionName));
            } else {
                DisabledPotions.this.broadcast(Messages.INVENTORY_POTION_DISABLE_CLICK.getMessage().replace("%potion%", potionName));
            }
            ItemStack potionItem = XMaterial.POTION.parseItem();
            this.updateItem(potionItem, data);
            return potionItem;
        }

        @NotNull
        protected ItemStack updateItem(@NotNull ItemStack potionItem, @NotNull XPotionData potionData) {
            potionData.applyTo(potionItem);
            PotionMeta potionMeta = (PotionMeta)potionItem.getItemMeta();
            if (this.rule.isDisabled(potionData)) {
                Environment.setEnchantmentGlintOverride((ItemMeta)potionMeta, true);
                potionMeta.setLore(Collections.singletonList(Messages.INVENTORY_POTION_DISABLE.getMessage()));
                potionItem.setAmount(64);
            } else {
                Environment.setEnchantmentGlintOverride((ItemMeta)potionMeta, false);
                potionMeta.setLore(Collections.singletonList(Messages.INVENTORY_POTION_ENABLE.getMessage()));
                potionItem.setAmount(1);
            }
            potionItem.setItemMeta((ItemMeta)potionMeta);
            return potionItem;
        }

        @NotNull
        public Inventory getInventory() {
            return this.inventory;
        }
    }

    private class EditorPaper
    extends Editor {
        public EditorPaper(Fk plugin) {
            super(plugin);
        }

        @Override
        @NotNull
        protected ItemStack updateItem(@NotNull ItemStack potionItem, @NotNull XPotionData potionData) {
            Messages lore;
            potionData.applyTo(potionItem);
            if (this.rule.isDisabled(potionData)) {
                lore = Messages.INVENTORY_POTION_DISABLE;
                potionItem.setData(DataComponentTypes.DAMAGE, (Object)9);
                potionItem.setData(DataComponentTypes.MAX_DAMAGE, (Object)10);
                potionItem.setData(DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
            } else {
                lore = Messages.INVENTORY_POTION_ENABLE;
                potionItem.resetData((DataComponentType)DataComponentTypes.DAMAGE);
                potionItem.resetData((DataComponentType)DataComponentTypes.MAX_DAMAGE);
                potionItem.setData(DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, (Object)false);
            }
            potionItem.setData(DataComponentTypes.LORE, (DataComponentBuilder)ItemLore.lore().addLine((ComponentLike)LegacyComponentSerializer.legacyAmpersand().deserialize(lore.getMessage())));
            return potionItem;
        }
    }
}

