/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.scoreboard.scoreboardcommands;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.ArgumentParser;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandResult;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandRole;
import fr.devsylone.fallenkingdom.commands.abstraction.FkCommand;
import fr.devsylone.fallenkingdom.display.GlobalDisplayService;
import fr.devsylone.fallenkingdom.exception.FkLightException;
import fr.devsylone.fallenkingdom.scoreboard.PlaceHolder;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.version.Version;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class SetLine
extends FkCommand {
    public SetLine() {
        super("setLine", "<i0;14:number> <text>", Messages.CMD_MAP_SCOREBOARD_SET_LINE, CommandRole.ADMIN);
    }

    @Override
    public CommandResult execute(Fk plugin, CommandSender sender, List<String> args, String label) {
        int maxLength;
        GlobalDisplayService service = plugin.getDisplayService();
        int previousSize = service.scoreboard().size();
        int line = ArgumentParser.parseScoreboardLine(service.scoreboard(), false, args.get(0), Messages.CMD_ERROR_SCOREBOARD_INVALID_LINE);
        String content = String.join((CharSequence)" ", args.subList(1, args.size()));
        int n = maxLength = Version.VersionType.V1_13.isHigherOrEqual() ? 64 : 32;
        if (content.length() > maxLength) {
            throw new FkLightException(Messages.CMD_ERROR_SCOREBOARD_TOO_MANY_CHARS);
        }
        service.setScoreboardLine(line, ChatColor.translateAlternateColorCodes((char)'&', (String)content));
        if (line < 0 || line > previousSize) {
            service.updateAll(new PlaceHolder[0]);
        } else {
            service.updateAllScoreboards(line);
        }
        return CommandResult.SUCCESS;
    }
}

