/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.teams.teamscommands;

import com.google.common.collect.ImmutableList;
import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.abstraction.AbstractCommand;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandResult;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandRole;
import fr.devsylone.fallenkingdom.commands.abstraction.FkParentCommand;
import fr.devsylone.fallenkingdom.commands.teams.teamscommands.chestsroom.ChestRoomCapture;
import fr.devsylone.fallenkingdom.commands.teams.teamscommands.chestsroom.ChestRoomEnabled;
import fr.devsylone.fallenkingdom.commands.teams.teamscommands.chestsroom.ChestRoomHealth;
import fr.devsylone.fallenkingdom.commands.teams.teamscommands.chestsroom.ChestRoomOffset;
import fr.devsylone.fallenkingdom.commands.teams.teamscommands.chestsroom.ChestRoomRegen;
import fr.devsylone.fallenkingdom.commands.teams.teamscommands.chestsroom.ChestRoomRemove;
import fr.devsylone.fallenkingdom.commands.teams.teamscommands.chestsroom.ChestRoomShow;
import fr.devsylone.fallenkingdom.commands.teams.teamscommands.chestsroom.ChestRoomSpawn;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.version.component.FkBook;
import fr.devsylone.fallenkingdom.version.component.FkComponent;
import fr.devsylone.fkpi.FkPI;
import fr.devsylone.fkpi.managers.ChestsRoomsManager;
import fr.devsylone.fkpi.teams.Base;
import fr.devsylone.fkpi.teams.CrystalCore;
import fr.devsylone.fkpi.teams.Nexus;
import fr.devsylone.fkpi.teams.Team;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ClickEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChestsRoom
extends FkParentCommand {
    private static final String BOOK_PERMISSION = "fallenkingdom.commands.team.chestsRoom.book";

    public ChestsRoom() {
        super("chestsRoom", (List<? extends AbstractCommand>)ImmutableList.builder().add((Object)new ChestRoomCapture()).add((Object)new ChestRoomEnabled()).add((Object)new ChestRoomHealth()).add((Object)new ChestRoomOffset()).add((Object)new ChestRoomRegen()).add((Object)new ChestRoomRemove()).add((Object)new ChestRoomShow()).add((Object)new ChestRoomSpawn()).build(), Messages.CMD_MAP_CHEST_ROOM, CommandRole.PLAYER);
    }

    @Override
    public CommandResult execute(Fk plugin, CommandSender sender, List<String> args, String label) {
        if (args.isEmpty()) {
            this.displayStatus(sender, plugin.getFkPI());
        } else {
            super.execute(plugin, sender, args, label);
        }
        if (sender instanceof Player && plugin.getCommandManager().hasPermission(sender, BOOK_PERMISSION)) {
            Base base = plugin.getFkPI().getTeamManager().getBase(((Player)sender).getLocation()).orElse(null);
            this.book(base).open((Player)sender);
        }
        return CommandResult.SUCCESS;
    }

    public void displayStatus(@NotNull CommandSender sender, @NotNull FkPI fkPI) {
        ChestsRoomsManager manager = fkPI.getChestsRoomsManager();
        boolean enabled = manager.isEnabled();
        sender.sendMessage(Messages.CMD_TEAM_CHEST_ROOM_STATUS.getMessage().replace("%state%", (enabled ? Messages.CMD_RULES_ACTIVATED : Messages.CMD_RULES_DEACTIVATED).getMessage()));
        if (enabled) {
            ArrayList<fr.devsylone.fkpi.teams.ChestsRoom> chestsRooms = new ArrayList<fr.devsylone.fkpi.teams.ChestsRoom>();
            ArrayList<CrystalCore> crystals = new ArrayList<CrystalCore>();
            for (Team team : fkPI.getTeamManager().getTeams()) {
                Base base = team.getBase();
                if (base == null) continue;
                Nexus nexus2 = base.getNexus();
                if (nexus2 instanceof fr.devsylone.fkpi.teams.ChestsRoom) {
                    chestsRooms.add((fr.devsylone.fkpi.teams.ChestsRoom)nexus2);
                    continue;
                }
                if (!(nexus2 instanceof CrystalCore)) continue;
                crystals.add((CrystalCore)nexus2);
            }
            if (!chestsRooms.isEmpty()) {
                sender.sendMessage(Messages.CMD_TEAM_CHEST_ROOM_STATUS_CHEST.getMessage() + ": " + chestsRooms.stream().map(nexus -> nexus.getBase().getTeam().toString()).collect(Collectors.joining(", ")));
                sender.sendMessage(Messages.CMD_TEAM_CHEST_ROOM_STATUS_CHEST_PARAMS.getMessage().replace("%offset%", String.valueOf(manager.getOffset())).replace("%offsetunit%", Messages.Unit.BLOCKS.tl(manager.getOffset())).replace("%time%", String.valueOf(manager.getCaptureTime())).replace("%timeunit%", Messages.Unit.SECONDS.tl(manager.getCaptureTime())));
            }
            if (!crystals.isEmpty()) {
                sender.sendMessage(Messages.CMD_TEAM_CHEST_ROOM_STATUS_CRYSTAL.getMessage() + ": " + crystals.stream().map(nexus -> nexus.getBase().getTeam().toString()).collect(Collectors.joining(", ")));
                sender.sendMessage(Messages.CMD_TEAM_CHEST_ROOM_STATUS_CRYSTAL_PARAMS.getMessage().replace("%health%", String.valueOf(manager.getCoreHealth())).replace("%regen%", String.valueOf(manager.getRegenerationPerMinute())).replace("%allyBonus%", String.valueOf(manager.getRegenerationPerMinutePerAlly())));
            }
        }
    }

    @NotNull
    public FkBook book(@Nullable Base base) {
        FkComponent title = FkComponent.text("ChestsRoom - Help", ChatColor.GREEN);
        FkComponent author = FkComponent.text("Devsylone", ChatColor.DARK_BLUE);
        FkComponent[] pages = new FkComponent[]{FkComponent.join(FkComponent.text(" Reconnaissance auto\n     de la salle des\n         coffres\n\n ", ChatColor.DARK_BLUE), FkComponent.text("[Activer]", ChatColor.DARK_GREEN).command("/fk team chestsRoom enabled true").hover("Clique pour activer"), FkComponent.space(), FkComponent.text("[D\u00e9sactiver]", ChatColor.DARK_RED).command("/fk team chestsRoom enabled false").hover("Clique pour d\u00e9sactiver"), FkComponent.text("\n   ", new ChatColor[0]), base == null ? FkComponent.space() : FkComponent.text("[Placer un cristal]", ChatColor.DARK_PURPLE).command("/fk team chestsRoom spawn " + base.getTeam().getName()).hover("Clique pour placer un c\u0153ur de base"), FkComponent.text("\n\n   ", new ChatColor[0]), FkComponent.text("> En savoir plus <", ChatColor.UNDERLINE).changePage(5).hover("Clique pour plus d'infos")), FkComponent.join(FkComponent.text(" Temps de la capture\n     de la salle des\n         coffres\n\n", ChatColor.DARK_BLUE), FkComponent.text("> 2 minutes", ChatColor.GREEN).command("/fk team chestsRoom captureTime 120"), FkComponent.newline(), FkComponent.text("> 1 minute", ChatColor.GREEN).command("/fk team chestsRoom captureTime 60"), FkComponent.newline(), FkComponent.text("> 50 secondes", ChatColor.GREEN).command("/fk team chestsRoom captureTime 50"), FkComponent.newline(), FkComponent.text("> 40 secondes", ChatColor.GREEN).command("/fk team chestsRoom captureTime 40"), FkComponent.newline(), FkComponent.text("> 30 secondes", ChatColor.GREEN).command("/fk team chestsRoom captureTime 30"), FkComponent.text("\n\n/fk team chestsRoom captureTime", new ChatColor[0])), FkComponent.join(FkComponent.text("Marge de la salle des coffres\n", ChatColor.DARK_BLUE), FkComponent.text("> 1 bloc", ChatColor.GREEN).command("/fk team chestsRoom offset 1"), FkComponent.newline(), FkComponent.text("> 2 blocs (Conseill\u00e9)", ChatColor.GREEN).command("/fk team chestsRoom offset 2"), FkComponent.newline(), FkComponent.text("> 3 blocs", ChatColor.GREEN).command("/fk team chestsRoom offset 3"), FkComponent.newline(), FkComponent.text("> 4 blocs", ChatColor.GREEN).command("/fk team chestsRoom offset 4"), FkComponent.newline(), FkComponent.text("> 5 blocs", ChatColor.GREEN).command("/fk team chestsRoom offset 5"), FkComponent.text("\n\n   ", new ChatColor[0]), FkComponent.text("> En savoir plus <", ChatColor.UNDERLINE).changePage(8).hover("Clique pour plus d'infos")), FkComponent.text("Explications\npages suivantes", new ChatColor[0]), FkComponent.text("\u21aa La gestion de la salle des coffres permet d'automatiser l'\u00e9limination d'une \u00e9quipe lorsque le plugin d\u00e9tecte qu'une \u00e9quipe l'a captur\u00e9e.\n\nDeux options sont disponibles :\n\n\n\n--->", new ChatColor[0]), FkComponent.text("1. Les coffres pos\u00e9s par les joueurs sont d\u00e9tect\u00e9s et une salle des coffres est g\u00e9n\u00e9r\u00e9e en fonction de leur position.\n\n2. L'administrateur de la partie place un cristal que les ennemis doivent frapper pour capturer la base.\n--->", new ChatColor[0]), FkComponent.join(FkComponent.text("En optant pour la premi\u00e8re option, chaque joueur peut visualiser \u00e0 tout moment de la partie sa salle des coffres gr\u00e2ce \u00e0 la commande", new ChatColor[0]), FkComponent.text(" /fk team chestsRoom show", ChatColor.DARK_PURPLE), FkComponent.text("\nVous \u00eates le seul \u00e0 voir votre salle des coffres.", ChatColor.RED)), FkComponent.text("\u21aa \u00c0 chaque fois qu'un joueur pose un coffre dans sa base, la salle des coffres \u00e9volue pour former une zone rectangulaire englobant tous les coffres pos\u00e9s (seulement en survie).\n\n--->", new ChatColor[0]), FkComponent.join(FkComponent.text("\u21aa La ", new ChatColor[0]), FkComponent.text("marge", ChatColor.AQUA), FkComponent.text(" ou ", new ChatColor[0]), FkComponent.text("offset", ChatColor.AQUA), FkComponent.text(" est le nombre de blocs qui se trouvent entre les coffres les plus proches de la limite de la salle des coffres et la limite de la salle elle-m\u00eame.\n\n", new ChatColor[0]), FkComponent.text("Exemple page suivante --->", ChatColor.GOLD)), FkComponent.join(FkComponent.text("Exemple", ChatColor.UNDERLINE, ChatColor.BOLD), FkComponent.text(" : Avec une marge de 2 blocs, lorsque vous allez poser un seul coffre, les dimensions de la salle seront de 5x5x5.\n\n", new ChatColor[0]), FkComponent.text("Screens\n\n", ChatColor.UNDERLINE, ChatColor.BOLD), FkComponent.text("     ", new ChatColor[0]), FkComponent.text("> En Vanilla <", ChatColor.UNDERLINE, ChatColor.LIGHT_PURPLE).interact(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://imgur.com/kRpAMkA")), FkComponent.text("\n\n   ", new ChatColor[0]), FkComponent.text("> Marge 2 blocs <", ChatColor.UNDERLINE, ChatColor.DARK_GREEN).interact(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://imgur.com/q1A1BfO")), FkComponent.text("\n\n   ", new ChatColor[0]), FkComponent.text("> Marge 4 blocs <", ChatColor.UNDERLINE, ChatColor.DARK_GREEN).interact(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://imgur.com/8flOtrC")))};
        return FkBook.book(title, author, pages);
    }

    @Override
    @NotNull
    public Map<String, CommandRole> getPermissions() {
        HashMap<String, CommandRole> permissions = new HashMap<String, CommandRole>(2);
        permissions.put(this.permission, this.role);
        permissions.put(BOOK_PERMISSION, CommandRole.ADMIN);
        return permissions;
    }
}

