/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.teams.teamscommands;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandResult;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandRole;
import fr.devsylone.fallenkingdom.commands.abstraction.FkCommand;
import fr.devsylone.fallenkingdom.scoreboard.PlaceHolder;
import fr.devsylone.fallenkingdom.utils.ChatUtils;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fkpi.teams.Team;
import fr.devsylone.fkpi.util.Color;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetColor
extends FkCommand {
    public SetColor() {
        super("setColor", "<team> <color>", Messages.CMD_MAP_TEAM_SET_COLOR, CommandRole.ADMIN);
    }

    @Override
    public CommandResult execute(Fk plugin, CommandSender sender, List<String> args, String label) {
        Team team = plugin.getFkPI().getTeamManager().getTeamOrThrow(args.get(0));
        try {
            team.setColor(Color.of(ChatUtils.unquoteString(args.get(1))));
        }
        catch (NumberFormatException ex) {
            SetColor.invalidColor(sender, args.get(1), ex);
            return CommandResult.INVALID_ARGS;
        }
        this.broadcast(Messages.CMD_TEAM_SET_COLOR.getMessage().replace("%team%", team.toString()).replace("%color%", team.getChatColor() + team.getColor().getGenredName(0)));
        plugin.getDisplayService().updateAll(new PlaceHolder[0]);
        return CommandResult.SUCCESS;
    }

    public static BaseComponent invalidColor(String value, NumberFormatException ex) {
        TranslatableComponent component = new TranslatableComponent("argument.color.invalid", new Object[0]);
        component.addWith(value);
        component.setColor(ChatColor.RED);
        component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(ex.getMessage())}));
        return component;
    }

    public static void invalidColor(CommandSender sender, String value, NumberFormatException ex) {
        if (sender instanceof Player) {
            ((Player)sender).spigot().sendMessage(SetColor.invalidColor(value, ex));
        } else {
            sender.sendMessage(SetColor.invalidColor(value, ex).toLegacyText());
        }
    }
}

