/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.commands.teams.teamscommands;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandResult;
import fr.devsylone.fallenkingdom.commands.abstraction.CommandRole;
import fr.devsylone.fallenkingdom.commands.abstraction.FkCommand;
import fr.devsylone.fallenkingdom.exception.FkLightException;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fkpi.teams.Team;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class TeamsList
extends FkCommand {
    public TeamsList() {
        super("list", Messages.CMD_MAP_TEAM_LIST, CommandRole.PLAYER);
    }

    @Override
    public CommandResult execute(Fk plugin, CommandSender sender, List<String> args, String label) {
        if (plugin.getFkPI().getTeamManager().getTeams().size() < 1) {
            throw new FkLightException(Messages.CMD_ERROR_NO_TEAM);
        }
        ArrayList<String> builder = new ArrayList<String>();
        builder.add(ChatColor.DARK_GREEN + "\u00a7m------------------- " + ChatColor.DARK_BLUE + (Object)((Object)Messages.CMD_TEAMS_AND_CHESTS_LIST) + ChatColor.DARK_GREEN + " \u00a7m-------------------");
        for (Team team : plugin.getFkPI().getTeamManager().getTeams()) {
            ChatColor color = team.getChatColor();
            builder.add(color + " " + team.getName() + " :");
            builder.add(color + " " + Messages.CMD_TEAM_LIST_PLAYERS.getMessage());
            if (!team.getPlayers().isEmpty()) {
                for (String pl : team.getPlayers()) {
                    builder.add(color + "     -" + pl);
                }
            } else {
                builder.add(color + "   \u00a74/");
            }
            if (team.getBase() == null) {
                builder.add(color + Messages.CMD_TEAM_LIST_POSITION.getMessage().replace("%x%", "\u00a74/" + color).replace("%y%", "\u00a74/" + color).replace("%z%", "\u00a74/" + color).replace("%dim%", ""));
            } else {
                Location center = team.getBase().getCenter();
                builder.add(color + Messages.CMD_TEAM_LIST_POSITION.getMessage().replace("%x%", String.valueOf(center.getBlockX()) + color).replace("%y%", String.valueOf(center.getBlockY()) + color).replace("%z%", String.valueOf(center.getBlockZ()) + color).replace("%dim%", this.getEnvironmentName(center) + color));
            }
            builder.add("\u00a72\u00a7m-----");
        }
        builder.set(builder.size() - 1, ChatColor.DARK_GREEN + "\u00a7m--------------------------------------------");
        sender.sendMessage(builder.toArray(new String[0]));
        return CommandResult.SUCCESS;
    }

    private String getEnvironmentName(Location location) {
        if (location.getWorld().getEnvironment().equals((Object)World.Environment.NORMAL)) {
            return "";
        }
        return " (" + location.getWorld().getEnvironment().name().toLowerCase().replace("_", " ") + ")";
    }
}

