/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.display;

import fr.devsylone.fallenkingdom.version.Version;
import fr.devsylone.fkpi.util.Saveable;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class DisplayText
implements Saveable {
    private static final String[] DEF_BOOLEANS = new String[]{"\u00a72\u2714", "\u00a74\u2718"};
    private String stringTrue = DEF_BOOLEANS[0];
    private String stringFalse = DEF_BOOLEANS[1];
    private String noInfo = "\u00a74?";
    private String arrows = this.defaultArrows();
    private static final String ARROWS = "arrows";
    private static final String BOOLS = "bools";
    private static final String NO_INFO = "no-info";

    @NotNull
    public String format(boolean value) {
        return value ? this.stringTrue : this.stringFalse;
    }

    @NotNull
    public String noInfo() {
        return this.noInfo;
    }

    @NotNull
    public String arrows() {
        return this.arrows;
    }

    public char arrowAt(@Range(from=0L, to=360L) int angle) {
        return this.arrows.charAt(angle / 45);
    }

    @Override
    public void load(ConfigurationSection config) {
        String[] booleans = config.getString(BOOLS, String.join((CharSequence)":", DEF_BOOLEANS)).split(":");
        if (booleans.length == 1) {
            booleans = DEF_BOOLEANS;
        }
        this.stringTrue = booleans[0];
        this.stringFalse = booleans[1];
        this.noInfo = config.getString(NO_INFO, this.noInfo);
        String defaultArrows = this.defaultArrows();
        String arrows = config.getString(ARROWS, defaultArrows);
        if (arrows.length() < defaultArrows.length()) {
            arrows = defaultArrows;
        }
        this.arrows = arrows;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(BOOLS, (Object)(this.stringTrue + ':' + this.stringFalse));
        config.set(NO_INFO, (Object)this.noInfo);
        config.set(ARROWS, (Object)this.arrows);
    }

    @NotNull
    private String defaultArrows() {
        if (Version.VersionType.V1_20.isHigherOrEqual()) {
            return "\u21e7\u2197\u21e8\u2198\u21e9\u2199\u21e6\u2196";
        }
        if (Version.VersionType.V1_16.isHigherOrEqual()) {
            return "\u21d1\u21d7\u21db\u21d9\u21d3\u21d8\u21d0\u21d6";
        }
        if (Version.VersionType.V1_13.isHigherOrEqual()) {
            return "\u21d1\u21d7\u21d2\u21d8\u21d3\u21d9\u21d0\u21d6";
        }
        return "\u2191\u2197\u2192\u2198\u2193\u2199\u2190\u2196";
    }
}

