/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.display;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.display.ActionBarDisplayService;
import fr.devsylone.fallenkingdom.display.DisplayService;
import fr.devsylone.fallenkingdom.display.DisplayText;
import fr.devsylone.fallenkingdom.display.DisplayType;
import fr.devsylone.fallenkingdom.display.MultipleBossBarDisplayService;
import fr.devsylone.fallenkingdom.display.ScoreboardDisplayService;
import fr.devsylone.fallenkingdom.display.SimpleDisplayService;
import fr.devsylone.fallenkingdom.display.change.DisplayChange;
import fr.devsylone.fallenkingdom.display.change.SetScoreboardLineChange;
import fr.devsylone.fallenkingdom.display.change.SetScoreboardTitleChange;
import fr.devsylone.fallenkingdom.display.content.Content;
import fr.devsylone.fallenkingdom.display.notification.ChatChannel;
import fr.devsylone.fallenkingdom.display.notification.GameNotification;
import fr.devsylone.fallenkingdom.display.notification.NotificationChannel;
import fr.devsylone.fallenkingdom.display.progress.ProgressBar;
import fr.devsylone.fallenkingdom.display.sound.SoundPlayer;
import fr.devsylone.fallenkingdom.display.tick.CycleTickFormatter;
import fr.devsylone.fallenkingdom.display.tick.TickFormatter;
import fr.devsylone.fallenkingdom.players.FkPlayer;
import fr.devsylone.fallenkingdom.scoreboard.PlaceHolder;
import fr.devsylone.fkpi.util.Saveable;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalDisplayService
implements DisplayService,
Saveable {
    private static final int STACK_MAX_SIZE = 10;
    private final DisplayText text = new DisplayText();
    private final Deque<DisplayChange<?>> revisions = new LinkedList();
    private Map<DisplayType, DisplayService> services;
    private ScoreboardDisplayService scoreboard;
    private ProgressBar.Provider barProvider = ProgressBar.Provider.EMPTY;
    private TickFormatter tickFormatter = new CycleTickFormatter();
    private SoundPlayer deathSound = SoundPlayer.EMPTY;
    private SoundPlayer gameStartSound = SoundPlayer.EMPTY;
    private SoundPlayer eliminationSound = SoundPlayer.EMPTY;
    private SoundPlayer eventSound = SoundPlayer.EMPTY;
    private NotificationChannel regionChangeDispatcher = new ChatChannel();
    public static final String FILENAME = "display.yml";
    private static final String SIDEBAR = "sidebar";
    private static final String TITLE = "title";
    private static final String DEATH_SOUND = "death-sound";
    private static final String GAME_START_SOUND = "game-start-sound";
    private static final String ELIMINATION_SOUND = "elimination-sound";
    private static final String EVENT_SOUND = "event-sound";
    private static final String PROGRESSBAR = "progressbar";
    private static final String TICK_FORMAT = "tick-format";
    private static final String NOTIFICATION = "notification";
    private static final String REGION_CHANGE = "region-change";

    public GlobalDisplayService() {
        this.services = Collections.emptyMap();
        this.scoreboard = new ScoreboardDisplayService();
    }

    @Override
    public boolean contains(@NotNull PlaceHolder placeHolder) {
        for (DisplayService service : this.services.values()) {
            if (!service.contains(placeHolder)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAny(PlaceHolder ... placeHolders) {
        for (DisplayService service : this.services.values()) {
            if (!service.containsAny(placeHolders)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void update(@NotNull Player player, @NotNull FkPlayer fkPlayer, PlaceHolder ... placeHolders) {
        if (this.isPreStart() && fkPlayer.getState() == FkPlayer.PlayerState.INGAME) {
            if (placeHolders.length == 0) {
                fkPlayer.refreshScoreboard();
            }
        } else {
            for (DisplayService service : this.services.values()) {
                service.update(player, fkPlayer, placeHolders);
            }
        }
    }

    @Override
    public void hide(@NotNull Player player, @NotNull FkPlayer fkPlayer) {
        for (DisplayService service : this.services.values()) {
            service.hide(player, fkPlayer);
        }
    }

    public void updateAll(PlaceHolder ... placeHolders) {
        boolean preStart = this.isPreStart();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!Fk.getInstance().getWorldManager().isAffected(player.getWorld())) continue;
            FkPlayer fkPlayer = Fk.getInstance().getPlayerManager().getPlayer((OfflinePlayer)player);
            if (preStart && fkPlayer.getState() == FkPlayer.PlayerState.INGAME) {
                if (placeHolders.length != 0) continue;
                fkPlayer.refreshScoreboard();
                continue;
            }
            for (DisplayService service : this.services.values()) {
                service.update(player, fkPlayer, placeHolders);
            }
        }
    }

    public void updateAllScoreboards(int line) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!Fk.getInstance().getWorldManager().isAffected(player.getWorld())) continue;
            FkPlayer fkPlayer = Fk.getInstance().getPlayerManager().getPlayer((OfflinePlayer)player);
            this.scoreboard.updateLine(player, fkPlayer, line);
        }
    }

    public void hideAll() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!Fk.getInstance().getWorldManager().isAffected(player.getWorld())) continue;
            FkPlayer fkPlayer = Fk.getInstance().getPlayerManager().getPlayer((OfflinePlayer)player);
            for (DisplayService service : this.services.values()) {
                service.hide(player, fkPlayer);
            }
        }
    }

    public boolean isPreStart() {
        return Fk.getInstance().getGame().isPreStart();
    }

    @NotNull
    public ScoreboardDisplayService scoreboard() {
        return this.scoreboard;
    }

    public void setScoreboard(@NotNull ScoreboardDisplayService scoreboard) {
        this.scoreboard = scoreboard;
        this.services.put(DisplayType.SCOREBOARD, scoreboard);
    }

    public boolean setScoreboardLine(int line, @Nullable String value) {
        SetScoreboardLineChange change = new SetScoreboardLineChange(this.scoreboard, line, value);
        this.pushChange(change);
        this.setScoreboard(change.apply(this.scoreboard));
        return true;
    }

    public void setScoreboardLines(@NotNull @NotNull List<@NotNull String> lines) {
        this.setScoreboard(this.scoreboard.withLines(lines));
    }

    public void setScoreboardTitle(@NotNull String title) {
        SetScoreboardTitleChange change = new SetScoreboardTitleChange(this.scoreboard, title);
        this.pushChange(change);
        this.setScoreboard(change.apply(this.scoreboard));
    }

    private void pushChange(@NotNull DisplayChange<?> change) {
        this.revisions.push(change);
        if (this.revisions.size() > 10) {
            this.revisions.removeFirst();
        }
    }

    @NotNull
    public DisplayText text() {
        return this.text;
    }

    @Override
    public void load(ConfigurationSection config) {
        ConfigurationSection section;
        this.hideAll();
        EnumMap<DisplayType, DisplayService> services = new EnumMap<DisplayType, DisplayService>(DisplayType.class);
        if (config.contains(DisplayType.ACTIONBAR.asString())) {
            section = config.getConfigurationSection(DisplayType.ACTIONBAR.asString());
            if (section != null) {
                services.put(DisplayType.ACTIONBAR, new ActionBarDisplayService(section));
            } else {
                services.put(DisplayType.ACTIONBAR, new ActionBarDisplayService(Content.fromConfig(config.get(DisplayType.ACTIONBAR.asString()))));
            }
        }
        if (config.contains(DisplayType.BOSSBAR.asString())) {
            section = Objects.requireNonNull(config.getConfigurationSection(DisplayType.BOSSBAR.asString()), "bossbar config has no section");
            services.put(DisplayType.BOSSBAR, new MultipleBossBarDisplayService(section));
        }
        if (config.contains(DisplayType.SCOREBOARD.asString())) {
            section = Objects.requireNonNull(config.getConfigurationSection(DisplayType.SCOREBOARD.asString()), "scoreboard config has no section");
            this.scoreboard = new ScoreboardDisplayService(section.getString(TITLE, ""), section.getStringList(SIDEBAR));
        } else {
            this.scoreboard = ScoreboardDisplayService.createDefault();
        }
        services.put(DisplayType.SCOREBOARD, this.scoreboard);
        this.barProvider = ProgressBar.Provider.fromConfig(config.getConfigurationSection(PROGRESSBAR));
        if (config.contains(TICK_FORMAT)) {
            this.tickFormatter = TickFormatter.fromConfig(Objects.requireNonNull(config.getConfigurationSection(TICK_FORMAT), "tick formatter config has no section"));
        }
        this.deathSound = SoundPlayer.fromConfig(config.getConfigurationSection(DEATH_SOUND), SoundPlayer.deathSound());
        this.gameStartSound = SoundPlayer.fromConfig(config.getConfigurationSection(GAME_START_SOUND), SoundPlayer.gameStartSound());
        this.eliminationSound = SoundPlayer.fromConfig(config.getConfigurationSection(ELIMINATION_SOUND), SoundPlayer.eliminationSound());
        this.eventSound = SoundPlayer.fromConfig(config.getConfigurationSection(EVENT_SOUND), SoundPlayer.eventSound());
        this.services = services;
        this.text.load(config);
        ConfigurationSection notification = config.getConfigurationSection(NOTIFICATION);
        if (notification != null) {
            this.regionChangeDispatcher = NotificationChannel.fromConfig(notification.getString(REGION_CHANGE));
        }
    }

    @Override
    public void loadNullable(ConfigurationSection config) {
        this.load((ConfigurationSection)(config == null ? new MemoryConfiguration() : config));
    }

    @Override
    public void save(ConfigurationSection config) {
        for (Map.Entry<DisplayType, DisplayService> entry : this.services.entrySet()) {
            String key = entry.getKey().asString();
            DisplayService service = entry.getValue();
            if (service instanceof ScoreboardDisplayService) {
                ConfigurationSection section = config.createSection(key);
                section.set(TITLE, (Object)((ScoreboardDisplayService)service).title());
                section.set(SIDEBAR, ((ScoreboardDisplayService)service).lines());
                continue;
            }
            ((SimpleDisplayService)service).save(config.createSection(key));
        }
        this.barProvider.save(config.createSection(PROGRESSBAR));
        this.tickFormatter.save(config.createSection(TICK_FORMAT));
        this.deathSound.save(config.createSection(DEATH_SOUND));
        this.gameStartSound.save(config.createSection(GAME_START_SOUND));
        this.eliminationSound.save(config.createSection(ELIMINATION_SOUND));
        this.eventSound.save(config.createSection(EVENT_SOUND));
        this.text.save(config);
        ConfigurationSection notification = config.createSection(NOTIFICATION);
        notification.set(REGION_CHANGE, (Object)NotificationChannel.name(this.regionChangeDispatcher));
    }

    @NotNull
    public ProgressBar initProgressBar(@NotNull Player player, @NotNull Location location) {
        return this.barProvider.init(player, location);
    }

    @Contract(value="_ -> new")
    @NotNull
    public TickFormatter configureTickFormatter(int dayDuration) {
        return this.tickFormatter.withDayDuration(dayDuration);
    }

    @NotNull
    public TickFormatter baseTickFormatter() {
        return this.tickFormatter;
    }

    public void playDeathSound(@NotNull Player player) {
        this.deathSound.play(player);
    }

    public void playGameStartSound(@NotNull Player player) {
        this.gameStartSound.play(player);
    }

    public void playEliminationSound(@NotNull Player player) {
        this.eliminationSound.play(player);
    }

    public void playEventSound(@NotNull Player player) {
        this.eventSound.play(player);
    }

    public void dispatch(@NotNull GameNotification notification, @NotNull Player player) {
        this.regionChangeDispatcher.send(player, notification);
    }

    public boolean undo() {
        if (this.revisions.isEmpty()) {
            return false;
        }
        DisplayChange<?> change = this.revisions.pop();
        DisplayType type = change.type();
        DisplayService service = this.services.get((Object)type);
        if (service == null) {
            throw new IllegalStateException("Unable to recreate the display service.");
        }
        DisplayService changed = change.revert(service);
        this.services.put(type, changed);
        if (type == DisplayType.SCOREBOARD) {
            this.scoreboard = (ScoreboardDisplayService)changed;
        }
        return true;
    }
}

