/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.display;

import fr.devsylone.fallenkingdom.display.BossBarDisplayService;
import fr.devsylone.fallenkingdom.display.content.Content;
import fr.devsylone.fallenkingdom.players.FkPlayer;
import fr.devsylone.fallenkingdom.utils.ConfigHelper;
import fr.devsylone.fallenkingdom.utils.KeyHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultipleBossBarDisplayService
extends BossBarDisplayService {
    private final Map<UUID, KeyedBossBar> bars;
    private BarColor color;
    private BarStyle style;
    private static final String COLOR = "color";
    private static final String STYLE = "style";
    private static final String TITLE = "title";

    MultipleBossBarDisplayService(@NotNull ConfigurationSection section) {
        this(Content.fromConfig(section.get(TITLE)), ConfigHelper.enumValueOf(BarColor.class, section.getString(COLOR), BarColor.WHITE), ConfigHelper.enumValueOf(BarStyle.class, section.getString(STYLE), BarStyle.SOLID));
    }

    MultipleBossBarDisplayService(@NotNull Content content, @NotNull BarColor color, @NotNull BarStyle style) {
        this(content, color, style, new HashMap<UUID, KeyedBossBar>());
    }

    MultipleBossBarDisplayService(@NotNull Content content, @NotNull BarColor color, @NotNull BarStyle style, @NotNull Map<UUID, KeyedBossBar> bars) {
        super(content);
        this.color = color;
        this.style = style;
        this.bars = bars;
    }

    @Override
    public void show(@NotNull Player player, @NotNull String message) {
        BossBar existing = this.existingBar(player);
        if (existing == null) {
            KeyedBossBar bar = Bukkit.createBossBar((NamespacedKey)KeyHelper.plugin(player.getName()), (String)message, (BarColor)this.color, (BarStyle)this.style, (BarFlag[])new BarFlag[0]);
            bar.setVisible(true);
            bar.setProgress(1.0);
            bar.addPlayer(player);
            this.bars.put(player.getUniqueId(), bar);
        } else {
            existing.setTitle(message);
        }
    }

    @Override
    public void hide(@NotNull Player player, @NotNull FkPlayer fkPlayer) {
        KeyedBossBar removed = this.bars.remove(player.getUniqueId());
        if (removed != null) {
            removed.removePlayer(player);
            Bukkit.removeBossBar((NamespacedKey)removed.getKey());
        }
    }

    @Override
    @NotNull
    public BarColor color() {
        return this.color;
    }

    @Override
    public void withColor(@NotNull BarColor color) {
        this.color = Objects.requireNonNull(color, "bar color");
        for (BossBar bossBar : this.bars.values()) {
            bossBar.setColor(color);
        }
    }

    @Override
    @NotNull
    public BarStyle style() {
        return this.style;
    }

    @Override
    public void withStyle(@NotNull BarStyle style) {
        this.style = Objects.requireNonNull(style, "bar style");
        for (BossBar bossBar : this.bars.values()) {
            bossBar.setStyle(style);
        }
    }

    @Override
    @NotNull
    public MultipleBossBarDisplayService withValue(@NotNull Content next) {
        return new MultipleBossBarDisplayService(next, this.color, this.style, this.bars);
    }

    @Override
    void save(@NotNull ConfigurationSection section) {
        section.set(COLOR, (Object)this.color.name());
        section.set(STYLE, (Object)this.style.name());
        this.content().save(section, TITLE);
    }

    @Nullable
    private BossBar existingBar(@NotNull Player player) {
        return (BossBar)this.bars.get(player.getUniqueId());
    }
}

