/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.display;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.manager.WorldManager;
import fr.devsylone.fallenkingdom.version.Version;
import fr.devsylone.fkpi.managers.TeamManager;
import fr.devsylone.fkpi.teams.Team;
import fr.devsylone.fkpi.util.Saveable;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NametagService
implements Saveable {
    private Scoreboard scoreboard;
    private final TeamManager teamManager;
    private final WorldManager worldManager;
    private static final String USE_MAIN_SCOREBOARD = "use-main-scoreboard";

    public NametagService(@NotNull TeamManager teamManager) {
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        Scoreboard mainScoreboard = manager.getMainScoreboard();
        this.scoreboard = mainScoreboard.getTeams().isEmpty() ? mainScoreboard : manager.getNewScoreboard();
        this.teamManager = teamManager;
        this.worldManager = Fk.getInstance().getWorldManager();
    }

    public NametagService(@NotNull TeamManager teamManager, @NotNull WorldManager worldManager, @NotNull Scoreboard scoreboard) {
        this.scoreboard = scoreboard;
        this.teamManager = teamManager;
        this.worldManager = worldManager;
    }

    public void createHealthObjective() {
        if (this.scoreboard.getObjective("\u00a7c\u2764") == null) {
            this.scoreboard.registerNewObjective("\u00a7c\u2764", "health").setDisplaySlot(DisplaySlot.BELOW_NAME);
        }
    }

    public void removeHealthObjective() {
        Objective objective = this.scoreboard.getObjective("\u00a7c\u2764");
        if (objective != null) {
            objective.unregister();
        }
    }

    @NotNull
    public Scoreboard scoreboard() {
        return this.scoreboard;
    }

    public void createScoreboardTeam(@NotNull Team team) {
        this.getOrCreateScoreboardTeam(team);
    }

    public void removeScoreboardTeam(@NotNull Team fkTeam) {
        org.bukkit.scoreboard.Team team = this.scoreboard.getTeam(fkTeam.getName());
        if (team != null) {
            team.unregister();
        }
    }

    public void addEntry(@NotNull Team team, @NotNull String playerName, @Nullable Player player) {
        if (player == null || this.worldManager.isAffected(player.getWorld())) {
            this.getOrCreateScoreboardTeam(team).addEntry(playerName);
        }
        if (this.shouldHaveScoreboard(player)) {
            player.setDisplayName(team.getChatColor() + player.getName());
            player.setScoreboard(this.scoreboard);
        }
    }

    public void removeEntry(@NotNull Team team, @NotNull String playerName, @Nullable Player player) {
        this.getOrCreateScoreboardTeam(team).removeEntry(playerName);
        if (player != null) {
            player.setDisplayName(playerName);
            player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
        }
    }

    public void addEntry(@NotNull Player player) {
        Team team = this.teamManager.getPlayerTeam(player);
        if (team != null) {
            this.addEntry(team, player.getName(), player);
        }
    }

    public void removeEntry(@NotNull Player player) {
        Team team = this.teamManager.getPlayerTeam(player);
        if (team != null) {
            this.removeEntry(team, player.getName(), player);
        }
    }

    public void renameTeam(@NotNull Team fkTeam, @NotNull String previousName) {
        org.bukkit.scoreboard.Team team = this.getOrCreateScoreboardTeam(fkTeam);
        for (String entry : fkTeam.getPlayers()) {
            team.addEntry(entry);
        }
        team = this.scoreboard.getTeam(previousName);
        if (team != null) {
            team.unregister();
        }
    }

    public void updateColor(@NotNull Team fkTeam) {
        this.setTeamColor(this.getOrCreateScoreboardTeam(fkTeam), fkTeam);
    }

    public void teardown(@NotNull Iterable<Team> teams) {
        for (Team team : teams) {
            this.removeScoreboardTeam(team);
        }
        this.removeHealthObjective();
    }

    private void setTeamColor(org.bukkit.scoreboard.Team team, Team fkTeam) {
        if (Version.VersionType.V1_13.isHigherOrEqual()) {
            team.setColor(fkTeam.getColor().getBukkitChatColor());
        } else {
            team.setPrefix(String.valueOf(fkTeam.getColor().getBukkitChatColor()));
        }
    }

    @NotNull
    private org.bukkit.scoreboard.Team getOrCreateScoreboardTeam(@NotNull Team fkTeam) {
        org.bukkit.scoreboard.Team team = this.scoreboard.getTeam(fkTeam.getName());
        if (team != null) {
            return team;
        }
        team = this.scoreboard.registerNewTeam(fkTeam.getName());
        this.setTeamColor(team, fkTeam);
        return team;
    }

    @Contract(value="null -> false")
    private boolean shouldHaveScoreboard(@Nullable Player player) {
        return player != null && this.worldManager.isAffected(player.getWorld());
    }

    @Override
    public void load(ConfigurationSection config) {
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        this.scoreboard = config.getBoolean(USE_MAIN_SCOREBOARD) ? manager.getMainScoreboard() : manager.getNewScoreboard();
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(USE_MAIN_SCOREBOARD, (Object)(this.scoreboard == Bukkit.getScoreboardManager().getMainScoreboard() ? 1 : 0));
    }
}

