/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.display;

import fr.devsylone.fallenkingdom.display.DisplayService;
import fr.devsylone.fallenkingdom.display.content.ConstantContent;
import fr.devsylone.fallenkingdom.players.FkPlayer;
import fr.devsylone.fallenkingdom.scoreboard.PlaceHolder;
import fr.devsylone.fallenkingdom.utils.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ScoreboardDisplayService
implements DisplayService {
    private final ConstantContent title;
    private final List<ConstantContent> lines;
    private final Map<PlaceHolder, List<Integer>> placeHolders;

    public ScoreboardDisplayService() {
        this("", Collections.emptyList());
    }

    public ScoreboardDisplayService(@NotNull String title, @NotNull @NotNull List<@NotNull String> lines) {
        this(new ConstantContent(title), lines.stream().map(ConstantContent::new).collect(Collectors.toList()));
    }

    public ScoreboardDisplayService(@NotNull ConstantContent title, @NotNull @NotNull List<@NotNull ConstantContent> lines) {
        this.title = Objects.requireNonNull(title, "scoreboard title");
        Objects.requireNonNull(lines, "scoreboard lines");
        if (lines.isEmpty()) {
            this.lines = Collections.emptyList();
            this.placeHolders = Collections.emptyMap();
            return;
        }
        this.lines = new ArrayList<ConstantContent>(lines);
        this.placeHolders = new EnumMap<PlaceHolder, List<Integer>>(PlaceHolder.class);
        for (int i = 0; i < lines.size(); ++i) {
            String value = Objects.requireNonNull(lines.get(i), "scoreboard line").content();
            for (PlaceHolder placeholder : PlaceHolder.values()) {
                if (!value.contains(placeholder.getKey())) continue;
                this.placeHolders.computeIfAbsent(placeholder, s -> new ArrayList(2)).add(i);
            }
        }
    }

    @NotNull
    public static ScoreboardDisplayService createDefault() {
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(Messages.SCOREBOARD_DEFAULT.getMessage().split("\n")));
        lines.add("\u00a71\u00a7odevsylone");
        return new ScoreboardDisplayService(Messages.PREFIX_FK.getMessage(), lines);
    }

    @Override
    public boolean contains(@NotNull PlaceHolder placeHolder) {
        return this.placeHolders.containsKey((Object)placeHolder);
    }

    @Override
    public boolean containsAny(PlaceHolder ... placeHolders) {
        for (PlaceHolder placeHolder : placeHolders) {
            if (!this.placeHolders.containsKey((Object)placeHolder)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void update(@NotNull Player player, @NotNull FkPlayer fkPlayer, PlaceHolder ... placeHolders) {
        if (placeHolders.length == 0) {
            fkPlayer.getScoreboard().updateLines(this.renderLines(player, fkPlayer));
            return;
        }
        HashSet<Integer> visitedLines = new HashSet<Integer>();
        for (PlaceHolder placeHolderToRerender : placeHolders) {
            List<Integer> lines = this.placeHolders.get((Object)placeHolderToRerender);
            if (lines == null) continue;
            for (Integer line : lines) {
                if (visitedLines.contains(line)) continue;
                fkPlayer.getScoreboard().updateLine(line, this.renderLine(player, fkPlayer, line));
                visitedLines.add(line);
            }
        }
    }

    @Override
    public void hide(@NotNull Player player, @NotNull FkPlayer fkPlayer) {
        fkPlayer.removeScoreboard();
    }

    public void updateLine(@NotNull Player player, @NotNull FkPlayer fkPlayer, int line) {
        fkPlayer.getScoreboard().updateLine(line, this.renderLine(player, fkPlayer, line));
    }

    public int reverseIndex(int index) {
        return this.size() - index - 1;
    }

    @NotNull
    public String renderLine(@NotNull Player player, @NotNull FkPlayer fkPlayer, int line) {
        return this.lines.get(line).format(player, fkPlayer, new PlaceHolder[0]);
    }

    @NotNull
    public String title() {
        return this.title.content();
    }

    @NotNull
    public @NotNull @Unmodifiable List<@NotNull String> lines() {
        return Collections.unmodifiableList(this.lines.stream().map(ConstantContent::content).collect(Collectors.toList()));
    }

    @NotNull
    public List<String> renderLines(@NotNull Player player, @NotNull FkPlayer fkPlayer) {
        ArrayList<String> rendered = new ArrayList<String>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            rendered.add(this.renderLine(player, fkPlayer, i));
        }
        return rendered;
    }

    @NotNull
    public String line(int index) {
        return this.lines.get(index).content();
    }

    public int size() {
        return this.lines.size();
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public ScoreboardDisplayService withLine(int line, @Nullable String value) {
        ArrayList<Object> lines;
        if (value == null) {
            if (0 > line || line >= this.size()) {
                throw new IllegalArgumentException("Index " + line + " of the line to be removed is invalid for length " + this.size() + ".");
            }
            lines = new ArrayList<ConstantContent>(this.lines);
            lines.remove(line);
        } else if (line < 0) {
            lines = new ArrayList<ConstantContent>(this.size() - line);
            lines.add(new ConstantContent(value));
            ScoreboardDisplayService.fillWith(lines, line + 1, 0);
            lines.addAll(this.lines);
        } else {
            lines = new ArrayList(Math.max(this.size(), line + 1));
            lines.addAll(this.lines);
            ScoreboardDisplayService.fillWith(lines, this.size(), line + 1);
            lines.set(line, new ConstantContent(value));
        }
        return new ScoreboardDisplayService(this.title, lines);
    }

    @Contract(value="_ -> new")
    @NotNull
    public ScoreboardDisplayService withLines(@NotNull @NotNull List<@NotNull String> lines) {
        return new ScoreboardDisplayService(this.title, lines.stream().map(ConstantContent::new).collect(Collectors.toList()));
    }

    @Contract(value="_ -> new")
    public ScoreboardDisplayService withTitle(@NotNull String title) {
        return new ScoreboardDisplayService(new ConstantContent(title), this.lines);
    }

    public boolean isDefaultSidebar() {
        String[] def = Messages.SCOREBOARD_DEFAULT.getMessage().split("\n");
        if (def.length != this.lines.size() && def.length != this.lines.size() - 1) {
            return false;
        }
        for (int i = 0; i < def.length; ++i) {
            if (def[i].equals(this.lines.get(i).content())) continue;
            return false;
        }
        return true;
    }

    private static void fillWith(@NotNull @NotNull List<@NotNull ConstantContent> lines, int from, int to) {
        for (int i = from; i < to; ++i) {
            lines.add(new ConstantContent(""));
        }
    }
}

