/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.display;

import fr.devsylone.fallenkingdom.display.DisplayService;
import fr.devsylone.fallenkingdom.display.DisplayType;
import fr.devsylone.fallenkingdom.display.content.Content;
import fr.devsylone.fallenkingdom.players.FkPlayer;
import fr.devsylone.fallenkingdom.scoreboard.PlaceHolder;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class SimpleDisplayService
implements DisplayService {
    private final DisplayType type;
    private final Content content;

    public SimpleDisplayService(@NotNull DisplayType type, @NotNull Content content) {
        if (type == DisplayType.SCOREBOARD) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.content = content;
    }

    @Override
    public boolean contains(@NotNull PlaceHolder placeHolder) {
        return this.content.contains(placeHolder);
    }

    @Override
    public boolean containsAny(PlaceHolder ... placeHolders) {
        return this.content.containsAny(placeHolders);
    }

    @Override
    public void update(@NotNull Player player, @NotNull FkPlayer fkPlayer, PlaceHolder ... placeHolders) {
        if (placeHolders.length != 0 && !this.containsAny(placeHolders)) {
            return;
        }
        this.show(player, this.content.format(player, fkPlayer, placeHolders));
    }

    public abstract void show(@NotNull Player var1, @NotNull String var2);

    @NotNull
    public Content content() {
        return this.content;
    }

    @Contract(value="_ -> new")
    @NotNull
    public abstract SimpleDisplayService withValue(@NotNull Content var1);

    @NotNull
    public DisplayType type() {
        return this.type;
    }

    abstract void save(@NotNull ConfigurationSection var1);
}

