/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.display.change;

import fr.devsylone.fallenkingdom.display.DisplayType;
import fr.devsylone.fallenkingdom.display.ScoreboardDisplayService;
import fr.devsylone.fallenkingdom.display.change.DisplayChange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetScoreboardLineChange
implements DisplayChange<ScoreboardDisplayService> {
    private final int line;
    private final String previous;
    private final String next;

    public SetScoreboardLineChange(@NotNull ScoreboardDisplayService scoreboard, int line, @Nullable String next) {
        this.line = line;
        this.previous = 0 <= line && line < scoreboard.size() ? scoreboard.line(line) : null;
        this.next = next;
    }

    @Override
    @NotNull
    public ScoreboardDisplayService apply(@NotNull ScoreboardDisplayService actual) {
        return actual.withLine(this.line, this.next);
    }

    @Override
    @NotNull
    public ScoreboardDisplayService revert(@NotNull ScoreboardDisplayService next) {
        return next.withLine(this.line, this.previous);
    }

    @Override
    @NotNull
    public DisplayType type() {
        return DisplayType.SCOREBOARD;
    }

    public String toString() {
        return "SetScoreboardLineChange{line=" + this.line + ", previous='" + this.previous + '\'' + ", next='" + this.next + '\'' + '}';
    }
}

