/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.display.content;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.display.content.Content;
import fr.devsylone.fallenkingdom.players.FkPlayer;
import fr.devsylone.fallenkingdom.scoreboard.PlaceHolder;
import fr.devsylone.fallenkingdom.utils.ChatUtils;
import fr.devsylone.fallenkingdom.version.Version;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ConstantContent
implements Content {
    private static final boolean PAPI_ENABLED = Version.classExists("me.clip.placeholderapi.PlaceholderAPI");
    private final String value;
    private final Set<PlaceHolder> placeHolders;
    private final boolean hasPapiPlaceholders;

    public ConstantContent(@NotNull String value) {
        this.value = Objects.requireNonNull(value, "display value");
        if (!value.contains("{") || !value.contains("}")) {
            this.placeHolders = Collections.emptySet();
        } else {
            this.placeHolders = EnumSet.noneOf(PlaceHolder.class);
            for (PlaceHolder placeholder : PlaceHolder.values()) {
                if (!value.contains(placeholder.getKey())) continue;
                this.placeHolders.add(placeholder);
            }
        }
        this.hasPapiPlaceholders = PAPI_ENABLED && value.contains("%") && value.indexOf(37) != value.lastIndexOf(37);
    }

    @Override
    public boolean contains(@NotNull PlaceHolder placeHolder) {
        return this.placeHolders.contains((Object)placeHolder);
    }

    @Override
    public boolean containsAny(PlaceHolder ... placeHolders) {
        for (PlaceHolder placeHolder : placeHolders) {
            if (!this.placeHolders.contains((Object)placeHolder)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String format(@NotNull Player player, @NotNull FkPlayer fkPlayer, PlaceHolder ... placeHolders) {
        if (fkPlayer.useFormattedText()) {
            String replaced = this.value;
            for (PlaceHolder placeHolder : this.placeHolders) {
                replaced = placeHolder.replaceMultiple(replaced, player);
            }
            if (this.hasPapiPlaceholders) {
                try {
                    replaced = PlaceholderAPI.setPlaceholders((Player)player, (String)replaced);
                }
                catch (Exception e) {
                    Fk.getInstance().getLogger().log(Level.WARNING, "Erreur lors du traitement des placeholders PAPI", e);
                }
            }
            return replaced;
        }
        return ChatUtils.translateColorCodeToAmpersand(this.value);
    }

    @Override
    public void save(@NotNull ConfigurationSection parent, @NotNull String name) {
        parent.set(name, (Object)this.value);
    }

    @NotNull
    public String content() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConstantContent)) {
            return false;
        }
        ConstantContent that = (ConstantContent)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "\"" + this.value + "\"";
    }
}

