/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.display.content;

import fr.devsylone.fallenkingdom.display.content.BaseDependantContent;
import fr.devsylone.fallenkingdom.display.content.ConstantContent;
import fr.devsylone.fallenkingdom.display.content.InterruptibleContent;
import fr.devsylone.fallenkingdom.players.FkPlayer;
import fr.devsylone.fallenkingdom.scoreboard.PlaceHolder;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Content {
    default public boolean contains(@NotNull PlaceHolder placeHolder) {
        return this.containsAny(placeHolder);
    }

    public boolean containsAny(PlaceHolder ... var1);

    @NotNull
    public String format(@NotNull Player var1, @NotNull FkPlayer var2, PlaceHolder ... var3);

    public void save(@NotNull ConfigurationSection var1, @NotNull String var2);

    @NotNull
    public static Content fromConfig(@Nullable Object config) {
        if (config instanceof ConfigurationSection) {
            ConfigurationSection section = (ConfigurationSection)config;
            String type = section.getString("type");
            if ("base".equals(type)) {
                return new BaseDependantContent(Content.fromConfig(section.get("inside")), Content.fromConfig(section.get("outside")));
            }
            if ("interruptible".equals(type)) {
                return new InterruptibleContent(Content.fromConfig(section.get("interrupt")), Content.fromConfig(section.get("inner")));
            }
        }
        return new ConstantContent(String.valueOf(config));
    }
}

