/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.display.content;

import fr.devsylone.fallenkingdom.display.content.Content;
import fr.devsylone.fallenkingdom.players.FkPlayer;
import fr.devsylone.fallenkingdom.scoreboard.PlaceHolder;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class InterruptibleContent
implements Content {
    private final Content interrupt;
    private final Content inner;
    static final String INTERRUPTIBLE = "interruptible";
    static final String INTERRUPT = "interrupt";
    static final String INNER = "inner";

    public InterruptibleContent(@NotNull Content interrupt, @NotNull Content inner) {
        this.interrupt = interrupt;
        this.inner = inner;
    }

    @Override
    public boolean containsAny(PlaceHolder ... placeHolders) {
        return this.interrupt.containsAny(placeHolders) || this.inner.containsAny(placeHolders);
    }

    @Override
    @NotNull
    public String format(@NotNull Player player, @NotNull FkPlayer fkPlayer, PlaceHolder ... placeHolders) {
        String result = this.interrupt.format(player, fkPlayer, placeHolders);
        if (ChatColor.stripColor((String)result).isEmpty()) {
            result = this.inner.format(player, fkPlayer, placeHolders);
        }
        return result;
    }

    @Override
    public void save(@NotNull ConfigurationSection parent, @NotNull String name) {
        ConfigurationSection section = parent.createSection(name);
        section.set("type", (Object)INTERRUPTIBLE);
        this.interrupt.save(section, INTERRUPT);
        this.inner.save(section, INNER);
    }
}

