/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.display.notification;

import fr.devsylone.fallenkingdom.display.notification.GameNotification;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fkpi.FkPI;
import fr.devsylone.fkpi.teams.Base;
import fr.devsylone.fkpi.teams.Nexus;
import fr.devsylone.fkpi.teams.Team;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegionChange
implements GameNotification {
    private final Base base;
    private final Nexus nexus;
    private final MoveType moveType;
    private final long timestamp;

    public RegionChange(@NotNull Base base, @NotNull MoveType moveType) {
        this.base = base;
        this.nexus = null;
        this.moveType = moveType;
        this.timestamp = System.currentTimeMillis();
    }

    public RegionChange(@NotNull Nexus nexus, @NotNull MoveType moveType) {
        this.base = nexus.getBase();
        this.nexus = nexus;
        this.moveType = moveType;
        this.timestamp = System.currentTimeMillis();
    }

    @NotNull
    public Base getBase() {
        return this.base;
    }

    @Nullable
    public Nexus getNexus() {
        return this.nexus;
    }

    @NotNull
    public MoveType getMoveType() {
        return this.moveType;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    @NotNull
    public String message(@NotNull Player player) {
        Team pTeam = FkPI.getInstance().getTeamManager().getPlayerTeam(player);
        Team baseTeam = this.base.getTeam();
        Messages message = this.moveType == MoveType.ENTER ? (this.nexus == null ? (baseTeam.equals(pTeam) ? Messages.PLAYER_SELF_BASE_ENTER : Messages.PLAYER_BASE_ENTER) : (baseTeam.equals(pTeam) ? Messages.PLAYER_SELF_CHEST_ROOM_ENTER : Messages.PLAYER_CHEST_ROOM_ENTER)) : (this.nexus == null ? (baseTeam.equals(pTeam) ? Messages.PLAYER_SELF_BASE_EXIT : Messages.PLAYER_BASE_EXIT) : (baseTeam.equals(pTeam) ? Messages.PLAYER_SELF_CHEST_ROOM_EXIT : Messages.PLAYER_CHEST_ROOM_EXIT));
        return message.getMessage().replace("%team%", baseTeam.toString());
    }

    public String toString() {
        return "RegionChange{base=" + this.base.getTeam() + ", nexus=" + (this.nexus != null) + ", moveType=" + (Object)((Object)this.moveType) + ", timestamp=" + this.timestamp + "}";
    }

    public static enum MoveType {
        ENTER,
        LEAVE;

    }
}

