/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.display.progress;

import fr.devsylone.fallenkingdom.commands.ArgumentParser;
import fr.devsylone.fallenkingdom.display.progress.ProgressBar;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fkpi.util.Color;
import java.util.Arrays;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;

abstract class AbstractProgressBar
implements ProgressBar {
    private final ProviderImpl provider;

    AbstractProgressBar(@NotNull ProviderImpl provider) {
        this.provider = provider;
    }

    @NotNull
    protected String formatText(double progress) {
        String text = this.provider.text.replace("{PROGRESS}", ProgressBar.percent(progress));
        if (this.provider.totalBars == 0) {
            return text;
        }
        return text.substring(0, this.provider.barsStart) + this.progressBar('|', progress) + text.substring(this.provider.barsEnd + 1);
    }

    @NotNull
    protected String progressBar(char bar, double progress) {
        int completedBars = (int)((double)this.provider.totalBars * progress);
        return this.provider.completedColor + AbstractProgressBar.repeat(bar, completedBars) + this.provider.notCompletedColor + AbstractProgressBar.repeat(bar, this.provider.totalBars - completedBars);
    }

    @NotNull
    private static String repeat(char c, int repeat) {
        char[] chars = new char[repeat];
        Arrays.fill(chars, c);
        return new String(chars);
    }

    static abstract class ProviderImpl
    implements ProgressBar.Provider {
        protected static final String TYPE = "type";
        protected static final String TEXT = "text";
        protected static final String ACTIONBAR = "actionbar";
        protected static final String BOSSBAR = "bossbar";
        protected static final String HOLOGRAM = "hologram";
        private final String text;
        private final int barsStart;
        private final int barsEnd;
        private final int totalBars;
        private final ChatColor completedColor;
        private final ChatColor notCompletedColor;

        public ProviderImpl(@NotNull ConfigurationSection config) {
            this(config.getString(TEXT, "{PROGRESS}%"));
        }

        public ProviderImpl(@NotNull String text) {
            this.text = text;
            this.barsStart = text.indexOf("{BARS");
            this.barsEnd = text.indexOf(125, this.barsStart);
            if (this.barsStart != -1 && this.barsEnd != -1) {
                String[] params = text.substring(this.barsStart, this.barsEnd).split(":");
                this.totalBars = params.length > 1 ? ArgumentParser.parsePositiveInt(params[1], false, Messages.CMD_ERROR_POSITIVE_INT) : 10;
                this.completedColor = params.length > 2 ? Color.of(params[2]).getChatColor() : ChatColor.BLUE;
                this.notCompletedColor = params.length > 3 ? Color.of(params[3]).getChatColor() : ChatColor.GRAY;
            } else {
                this.totalBars = 0;
                this.completedColor = ChatColor.RESET;
                this.notCompletedColor = ChatColor.RESET;
            }
        }

        @Override
        @MustBeInvokedByOverriders
        public void save(@NotNull ConfigurationSection config) {
            config.set(TYPE, (Object)this.type());
            config.set(TEXT, (Object)this.text);
        }

        @NotNull
        abstract String type();
    }
}

