/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.display.progress;

import fr.devsylone.fallenkingdom.display.progress.AbstractProgressBar;
import fr.devsylone.fallenkingdom.display.progress.ProgressBar;
import fr.devsylone.fallenkingdom.utils.ConfigHelper;
import fr.devsylone.fallenkingdom.utils.KeyHelper;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

class BossBarProgress
extends AbstractProgressBar {
    private final KeyedBossBar bar;

    BossBarProgress(@NotNull AbstractProgressBar.ProviderImpl provider, @NotNull KeyedBossBar bar) {
        super(provider);
        this.bar = bar;
    }

    @Override
    public void progress(@NotNull Player player, @NotNull Location location, double progress) {
        this.bar.setProgress(progress);
        this.bar.setTitle(this.formatText(progress));
    }

    @Override
    public void remove(@NotNull Player player) {
        this.bar.removePlayer(player);
        Bukkit.removeBossBar((NamespacedKey)this.bar.getKey());
    }

    static class ProviderImpl
    extends AbstractProgressBar.ProviderImpl {
        private final BarColor color;
        private final BarStyle style;
        private static final String COLOR = "color";
        private static final String STYLE = "style";

        ProviderImpl(@NotNull ConfigurationSection config) {
            super(config);
            this.color = ConfigHelper.enumValueOf(BarColor.class, config.getString(COLOR), BarColor.WHITE);
            this.style = ConfigHelper.enumValueOf(BarStyle.class, config.getString(STYLE), BarStyle.SOLID);
        }

        @Override
        @NotNull
        public ProgressBar init(@NotNull Player player, @NotNull Location location) {
            KeyedBossBar bar = Bukkit.createBossBar((NamespacedKey)KeyHelper.plugin("progress_" + player.getName()), (String)"", (BarColor)this.color, (BarStyle)this.style, (BarFlag[])new BarFlag[0]);
            bar.setVisible(true);
            bar.addPlayer(player);
            return new BossBarProgress(this, bar);
        }

        @Override
        public void save(@NotNull ConfigurationSection config) {
            super.save(config);
            config.set(COLOR, (Object)this.color.name());
            config.set(STYLE, (Object)this.style.name());
        }

        @Override
        @NotNull
        String type() {
            return "bossbar";
        }
    }
}

